(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 13.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[    188427,       5178]
NotebookOptionsPosition[    183469,       5080]
NotebookOutlinePosition[    183865,       5096]
CellTagsIndexPosition[    183822,       5093]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell["Equiorthodiagonal  Quadrilaterals - Steiner point", "Title",
 CellChangeTimes->{{3.947133122765019*^9, 3.947133141273266*^9}, {
  3.947144439694456*^9, 3.947144443366682*^9}, {3.947339713636549*^9, 
  3.947339717251663*^9}, {3.954728574674156*^9, 3.954728576840864*^9}, {
  3.9547567434027576`*^9, 
  3.9547567507460327`*^9}},ExpressionUUID->"29001ab6-6556-7b4b-a45f-\
7ca429ca0ceb"],

Cell["\<\
This Notebook contains the proofs for the results about equi-orthodiagonal \
quadrilaterals in the paper \[OpenCurlyDoubleQuote]More Shapes of Central \
Quadrilaterals\[CloseCurlyDoubleQuote]
by Stanley Rabinowitz and Ercole Suppa, submitted to the International \
Journal of Computer Discovered Mathematics (http://www.journal-1.eu/) in July \
2025.

This Notebook is Copyright \[Copyright] July 2025 by Stanley Rabinowitz \
(stan.rabinowitz@comcast.net) and Ercole Suppa (ercolesuppa@gmail.com) and is \
published with open access . 
This Notebook is distributed under the terms of the Creative Commons \
Attribution License which permits any use, distribution, and reproduction in \
any medium, provided the original author and the source are credited. 
The baricentricas package must be loaded before running this Notebook . It \
can be obtained from http://garciacapitan.epizy.com/baricentricas/.\
\>", "Text",
 CellChangeTimes->{{3.947134015183899*^9, 3.947134126514601*^9}, {
  3.947134165027289*^9, 3.947134216283169*^9}, {3.947146196077376*^9, 
  3.947146197937656*^9}, {3.947147714654799*^9, 3.947147721422184*^9}, {
  3.947147756182218*^9, 3.947147799085409*^9}, {3.947147829468706*^9, 
  3.947147925478302*^9}, {3.947148657900776*^9, 3.947148664004244*^9}, {
  3.947339725299139*^9, 3.947339727179648*^9}, {3.954756786770439*^9, 
  3.9547567917073765`*^9}, {3.96141290577211*^9, 
  3.961412913578973*^9}},ExpressionUUID->"22c83543-03f0-524a-b077-\
52bf40ea5d06"],

Cell[CellGroupData[{

Cell["Setup", "Section",
 CellChangeTimes->{{3.94550589477663*^9, 3.9455059090976067`*^9}, {
  3.947131190260437*^9, 
  3.947131192227951*^9}},ExpressionUUID->"9f6088f9-a2be-3140-964a-\
e41e398b8645"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"<<", "baricentricas.m"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"$Assumptions", "=", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"a", ">", "0"}], ",", 
      RowBox[{"b", ">", "0"}], ",", 
      RowBox[{"c", ">", "0"}], ",", 
      RowBox[{
       RowBox[{"a", "+", "b", "-", "c"}], ">", "0"}], ",", 
      RowBox[{
       RowBox[{"a", "+", "c", "-", "b"}], ">", "0"}], ",", 
      RowBox[{
       RowBox[{"b", "+", "c", "-", "a"}], ">", "0"}]}], "}"}]}], ";"}], 
  "\[IndentingNewLine]", "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{"condition", " ", "for", " ", "orthodiagonal", " ", "quad"}], 
   "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{"ortho", "=", 
  RowBox[{
   RowBox[{
    RowBox[{"Perpendicular", "[", 
     RowBox[{"ptB", ",", "rtCA"}], "]"}], ".", 
    RowBox[{"{", 
     RowBox[{"p", ",", "q", ",", "r"}], "}"}]}], "==", "0"}]}]}], "Input",
 CellChangeTimes->{{3.945504565162958*^9, 3.94550458198252*^9}, {
   3.9455170892604294`*^9, 3.945517091156999*^9}, {3.946437513579389*^9, 
   3.946437514387348*^9}, {3.946437922994858*^9, 3.946437998083948*^9}, {
   3.947131229988783*^9, 3.9471312337408752`*^9}, {3.94713126947538*^9, 
   3.947131271053065*^9}, {3.9471314397563486`*^9, 3.947131528028438*^9}, {
   3.947131689741032*^9, 3.947131695924305*^9}, {3.947131733918829*^9, 
   3.947131775067988*^9}, 3.94713185451009*^9, {3.947132455427481*^9, 
   3.947132456035076*^9}, {3.947133799219084*^9, 3.947133799613205*^9}, {
   3.9471447897267284`*^9, 3.9471448143356647`*^9}, {3.947339795568245*^9, 
   3.9473398095558796`*^9}, {3.9547552492897663`*^9, 3.954755284434631*^9}, {
   3.961123005514349*^9, 3.961123010118988*^9}},
 CellLabel->
  "In[268]:=",ExpressionUUID->"7895159c-a127-8b44-944b-25ce84d4f88d"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", 
       SuperscriptBox["a", "2"]}], "+", 
      SuperscriptBox["b", "2"], "+", 
      SuperscriptBox["c", "2"]}], ")"}], " ", "p"}], "+", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", 
       SuperscriptBox["a", "2"]}], "-", 
      SuperscriptBox["b", "2"], "+", 
      SuperscriptBox["c", "2"]}], ")"}], " ", "r"}]}], "\[Equal]", 
  "0"}]], "Output",
 CellChangeTimes->{3.947339807338928*^9, 3.947339859159481*^9, 
  3.947339905318266*^9, 3.947339989147003*^9, 3.947376863375458*^9, 
  3.947377688860035*^9, 3.947399223530634*^9, 3.9475699928518295`*^9, 
  3.954731828747135*^9, 3.954755798278473*^9, 3.954757132919309*^9, 
  3.955530239605236*^9, 3.956299221684908*^9, 3.956299272871298*^9, 
  3.961122675019829*^9, 3.9611230205633507`*^9, 3.961412944764154*^9},
 CellLabel->
  "Out[270]=",ExpressionUUID->"65da89bb-a627-48ff-9d4d-23258ae282d1"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{"condition", " ", "for", " ", "equidiagonal", " ", "quad"}], 
   "*)"}], "\[IndentingNewLine]", 
  RowBox[{"equi", "=", 
   RowBox[{"Eliminate", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"u", "==", "b"}], ",", 
       RowBox[{
        RowBox[{"u", "^", "2"}], "==", 
        RowBox[{"CuadradoDistancia", "[", 
         RowBox[{"ptB", ",", 
          RowBox[{"{", 
           RowBox[{"p", ",", "q", ",", "r"}], "}"}]}], "]"}]}]}], "}"}], ",", 
     RowBox[{"{", "u", "}"}]}], "]"}]}]}]], "Input",
 CellChangeTimes->{
  3.947339867867523*^9, {3.954755289456901*^9, 3.954755297218359*^9}, 
   3.9611230162891293`*^9},
 CellLabel->
  "In[271]:=",ExpressionUUID->"3eb12783-78d1-9b4d-8549-a0e447faf612"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{
    SuperscriptBox["b", "2"], " ", 
    SuperscriptBox["p", "2"]}], "-", 
   RowBox[{
    SuperscriptBox["c", "2"], " ", 
    SuperscriptBox["p", "2"]}], "+", 
   RowBox[{"2", " ", 
    SuperscriptBox["b", "2"], " ", "p", " ", "q"}], "+", 
   RowBox[{
    SuperscriptBox["b", "2"], " ", 
    SuperscriptBox["q", "2"]}], "-", 
   RowBox[{
    SuperscriptBox["a", "2"], " ", "p", " ", "r"}], "+", 
   RowBox[{"3", " ", 
    SuperscriptBox["b", "2"], " ", "p", " ", "r"}], "-", 
   RowBox[{
    SuperscriptBox["c", "2"], " ", "p", " ", "r"}], "+", 
   RowBox[{"2", " ", 
    SuperscriptBox["b", "2"], " ", "q", " ", "r"}], "-", 
   RowBox[{
    SuperscriptBox["a", "2"], " ", 
    SuperscriptBox["r", "2"]}], "+", 
   RowBox[{
    SuperscriptBox["b", "2"], " ", 
    SuperscriptBox["r", "2"]}]}], "\[Equal]", "0"}]], "Output",
 CellChangeTimes->{{3.947339865550669*^9, 3.947339868551458*^9}, 
   3.947339905342198*^9, 3.9473399891699715`*^9, 3.9473768637187634`*^9, 
   3.947377688882963*^9, 3.94739922387187*^9, 3.947569993193884*^9, {
   3.954731823939247*^9, 3.9547318287701416`*^9}, 3.954755798465472*^9, 
   3.95475713293631*^9, 3.955530239786241*^9, 3.956299272931334*^9, 
   3.961122676478176*^9, 3.9611230236311836`*^9, 3.961412944823039*^9},
 CellLabel->
  "Out[271]=",ExpressionUUID->"5231a96e-2ae2-4713-9357-a20b75b5d6ea"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{"assume", " ", "ABCD", " ", "convex", " ", "so", " ", "angle", 
     RowBox[{"(", "ACB", ")"}]}], "<", " ", 
    RowBox[{"90", "\[Degree]"}]}], "*)"}], "\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{
    "coordinates", " ", "of", " ", "point", " ", "D", " ", "of", " ", "an", " ",
      "equi"}], "-", 
    RowBox[{"orthodiagonal", " ", "quadrilateral", " ", "ABCD"}]}], "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{"ptD", "=", 
   RowBox[{"Last", "[", 
    RowBox[{
     RowBox[{"Map", "[", 
      RowBox[{"Simplificar", ",", 
       RowBox[{"Simplify", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"{", 
           RowBox[{"p", ",", "q", ",", "r"}], "}"}], "/.", 
          RowBox[{"Solve", "[", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{"ortho", ",", "equi"}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{"q", ",", "r"}], "}"}]}], "]"}]}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"p", ">", "0"}], ",", 
           RowBox[{
            RowBox[{
             SuperscriptBox["a", "2"], "+", 
             SuperscriptBox["b", "2"], "-", 
             SuperscriptBox["c", "2"]}], ">", "0"}]}], "}"}]}], "]"}]}], 
      "]"}], "/.", 
     RowBox[{
      SqrtBox[
       RowBox[{
        RowBox[{"-", 
         SuperscriptBox["a", "4"]}], "-", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "2"], "-", 
           SuperscriptBox["c", "2"]}], ")"}], "2"], "+", 
        RowBox[{"2", " ", 
         SuperscriptBox["a", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "2"], "+", 
           SuperscriptBox["c", "2"]}], ")"}]}]}]], "->", 
      RowBox[{"2", "S"}]}]}], "]"}]}]}]], "Input",
 CellChangeTimes->{{3.947339815820603*^9, 3.947339861421566*^9}, 
   3.947380060869086*^9, {3.947381792148802*^9, 3.947381796403881*^9}, {
   3.947384060266676*^9, 3.947384094395052*^9}, {3.9611226664562664`*^9, 
   3.961122666808956*^9}},
 CellLabel->
  "In[272]:=",ExpressionUUID->"ba7de94b-b034-de42-a94a-b67c19a69b18"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    SuperscriptBox["a", "2"], "+", 
    SuperscriptBox["b", "2"], "-", 
    SuperscriptBox["c", "2"]}], ",", 
   RowBox[{
    RowBox[{
     RowBox[{"-", "2"}], " ", 
     SuperscriptBox["b", "2"]}], "+", 
    RowBox[{"2", " ", "S"}]}], ",", 
   RowBox[{
    RowBox[{"-", 
     SuperscriptBox["a", "2"]}], "+", 
    SuperscriptBox["b", "2"], "+", 
    SuperscriptBox["c", "2"]}]}], "}"}]], "Output",
 CellChangeTimes->{{3.9473398297352505`*^9, 3.947339905370121*^9}, 
   3.9473399891958714`*^9, 3.9473768639394455`*^9, 3.947377688913883*^9, 
   3.9473800620104985`*^9, 3.947381797495817*^9, 3.947399224103514*^9, 
   3.947569993384405*^9, 3.954731829002188*^9, 3.954731989355959*^9, 
   3.954755798653469*^9, 3.954757132976309*^9, 3.955530239993238*^9, 
   3.956299273128328*^9, 3.961122679086481*^9, 3.9611230284865265`*^9, 
   3.9614129450301332`*^9},
 CellLabel->
  "Out[272]=",ExpressionUUID->"76f4824e-4e28-4223-9161-a716c8dce21b"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["Support routines", "Section",
 CellChangeTimes->{{3.850468990902514*^9, 3.850469001252577*^9}, {
  3.850469071318833*^9, 3.850469073637095*^9}, {3.850469177050805*^9, 
  3.85046919499736*^9}},ExpressionUUID->"fc2fcd82-4d50-ec47-b5a7-\
8944aef04ea5"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{
    "Rule", " ", "for", " ", "replacing", " ", "powers", " ", "of", " ", 
     "S"}], "=", 
    RowBox[{"2", "[", "ABC", "]"}]}], " ", "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"S2", "=", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", 
         SuperscriptBox["a", "4"]}], "+", 
        RowBox[{"2", " ", 
         SuperscriptBox["a", "2"], " ", 
         SuperscriptBox["b", "2"]}], "-", 
        SuperscriptBox["b", "4"], "+", 
        RowBox[{"2", " ", 
         SuperscriptBox["a", "2"], " ", 
         SuperscriptBox["c", "2"]}], "+", 
        RowBox[{"2", " ", 
         SuperscriptBox["b", "2"], " ", 
         SuperscriptBox["c", "2"]}], "-", 
        SuperscriptBox["c", "4"]}], ")"}], "/", "4"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"sustS", "=", 
     RowBox[{"{", 
      RowBox[{
       SuperscriptBox["S", "n_"], "\[Rule]", 
       RowBox[{
        SuperscriptBox["S2", 
         RowBox[{"Quotient", "[", 
          RowBox[{"n", ",", "2"}], "]"}]], 
        SuperscriptBox["S", 
         RowBox[{"Mod", "[", 
          RowBox[{"n", ",", "2"}], "]"}]]}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
    "Rule", " ", "for", " ", "replacing", " ", "Conway", " ", "symbols"}], 
    " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"sustC", "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"SA", "->", 
        RowBox[{
         RowBox[{"1", "/", "2"}], 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", 
            RowBox[{"a", "^", "2"}]}], "+", 
           RowBox[{"b", "^", "2"}], "+", 
           RowBox[{"c", "^", "2"}]}], ")"}]}]}], ",", " ", 
       RowBox[{"SB", "->", 
        RowBox[{
         RowBox[{"1", "/", "2"}], 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"a", "^", "2"}], "-", 
           RowBox[{"b", "^", "2"}], "+", 
           RowBox[{"c", "^", "2"}]}], ")"}]}]}], ",", " ", 
       RowBox[{"SC", "->", 
        RowBox[{
         RowBox[{"1", "/", "2"}], 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"a", "^", "2"}], "+", 
           RowBox[{"b", "^", "2"}], "-", 
           RowBox[{"c", "^", "2"}]}], ")"}]}]}], ",", " ", 
       RowBox[{"SW", "->", 
        RowBox[{
         RowBox[{"1", "/", "2"}], 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"a", "^", "2"}], "+", 
           RowBox[{"b", "^", "2"}], "+", 
           RowBox[{"c", "^", "2"}]}], ")"}]}]}]}], "}"}]}], ";"}], " ", 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", 
    RowBox[{
    "central", " ", "quadrilateral", " ", "of", " ", "ABCD", " ", "wrt", " ", 
     "a", " ", "point", " ", "E"}], "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"radialTrianglesOfQuadrilateral", "[", "ptE_", "]"}], ":=", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"ptA", ",", "ptB", ",", "ptE"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"ptB", ",", "ptC", ",", "ptE"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"ptC", ",", "ptD", ",", "ptE"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"ptD", ",", "ptA", ",", "ptE"}], "}"}]}], "}"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"centralQuadrilateral", "[", 
      RowBox[{"n_Integer", ",", "ptE_"}], "]"}], ":=", 
     RowBox[{"Map", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"Simplificar", "[", 
         RowBox[{"CentroETCTriangulo", "[", 
          RowBox[{
           RowBox[{"ETC", "[", 
            RowBox[{"[", 
             RowBox[{"n", ",", "2"}], "]"}], "]"}], ",", "#"}], "]"}], "]"}], 
        "&"}], ",", 
       RowBox[{"radialTrianglesOfQuadrilateral", "[", "ptE", "]"}]}], "]"}]}],
     ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"centralQuadrilateral", "[", 
      RowBox[{"ptX_", ",", "ptE_"}], "]"}], ":=", 
     RowBox[{"Map", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"Simplificar", "[", 
         RowBox[{"CentroETCTriangulo", "[", 
          RowBox[{"ptX", ",", "#"}], "]"}], "]"}], "&"}], ",", 
       RowBox[{"radialTrianglesOfQuadrilateral", "[", "ptE", "]"}]}], "]"}]}],
     ";"}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", 
    RowBox[{
    "Steiner", " ", "point", " ", "of", " ", "a", " ", "quadrilateral"}], 
    "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"SteinerPoint", "[", 
      RowBox[{"{", 
       RowBox[{"P_", ",", "Q_", ",", "R_", ",", "S_"}], "}"}], "]"}], ":=", 
     RowBox[{"Module", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
        "X", ",", "Y", ",", "Z", ",", "T", ",", "U", ",", "V", ",", "W"}], 
        "}"}], ",", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{
         RowBox[{"{", 
          RowBox[{"X", ",", "Y", ",", "Z", ",", "U", ",", "T"}], "}"}], "=", 
         RowBox[{
          RowBox[{
           RowBox[{"Apply", "[", 
            RowBox[{"Medio", ",", "#"}], "]"}], "&"}], "/@", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{"P", ",", "S"}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{"P", ",", "Q"}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{"R", ",", "Q"}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{"P", ",", "R"}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{"S", ",", "Q"}], "}"}]}], "}"}]}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"V", ",", "W"}], "}"}], "=", 
         RowBox[{
          RowBox[{
           RowBox[{"Circuncentro", "[", "#", "]"}], "&"}], "/@", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{"X", ",", "Y", ",", "U"}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{"Y", ",", "Z", ",", "T"}], "}"}]}], "}"}]}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"SimetriaAxial", "[", 
         RowBox[{"Y", ",", 
          RowBox[{"Recta", "[", 
           RowBox[{"V", ",", "W"}], "]"}]}], "]"}]}]}], "\[IndentingNewLine]",
       "]"}]}], ";"}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", 
    RowBox[{"tests", " ", "for", "  ", "perpendicularity"}], "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"perpendicularQ", "[", 
      RowBox[{"r_", ",", "s_", ",", 
       RowBox[{"cond_", ":", "True"}]}], "]"}], ":=", 
     RowBox[{
      RowBox[{"Simplify", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"Expand", "[", 
          RowBox[{
           RowBox[{"PuntoInfinitoPerpendicular", "[", 
            RowBox[{"PuntoInfinito", "[", "r", "]"}], "]"}], ".", "s"}], 
          "]"}], "/.", "sustS"}], ",", "cond"}], "]"}], "===", "0"}]}], ";"}],
    "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", 
    RowBox[{"tests", " ", "for", " ", "orthodiagonal", " ", "quadrilateral"}],
     "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"orthodiagonalQuadQ", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"P_", ",", "Q_", ",", "R_", ",", "S_"}], "}"}], ",", 
       RowBox[{"cond_", ":", "True"}]}], "]"}], ":=", 
     RowBox[{"Or", "[", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"perpendicularQ", "[", 
        RowBox[{
         RowBox[{"Recta", "[", 
          RowBox[{"P", ",", "Q"}], "]"}], ",", 
         RowBox[{"Recta", "[", 
          RowBox[{"R", ",", "S"}], "]"}], ",", "cond"}], "]"}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"perpendicularQ", "[", 
        RowBox[{
         RowBox[{"Recta", "[", 
          RowBox[{"P", ",", "S"}], "]"}], ",", 
         RowBox[{"Recta", "[", 
          RowBox[{"Q", ",", "R"}], "]"}], ",", "cond"}], "]"}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"perpendicularQ", "[", 
        RowBox[{
         RowBox[{"Recta", "[", 
          RowBox[{"P", ",", "R"}], "]"}], ",", 
         RowBox[{"Recta", "[", 
          RowBox[{"Q", ",", "S"}], "]"}], ",", "cond"}], "]"}]}], 
      "\[IndentingNewLine]", "]"}]}], ";"}]}]}]], "Input",
 CellChangeTimes->{{3.954755422028537*^9, 3.954755444302299*^9}, {
   3.954755510189615*^9, 3.9547556654655304`*^9}, {3.954756246303211*^9, 
   3.954756258310093*^9}, {3.954756539544531*^9, 3.954756557385113*^9}, {
   3.954756592197891*^9, 3.954756630631082*^9}, {3.954756965437847*^9, 
   3.954756984534746*^9}, {3.9547570451409245`*^9, 3.9547570732294483`*^9}, {
   3.9547571716004887`*^9, 3.9547571856117535`*^9}, {3.9547572771795826`*^9, 
   3.954757312322375*^9}, {3.95475745528866*^9, 3.954757469730625*^9}, {
   3.954757619426098*^9, 3.9547576217454853`*^9}, 3.954757823439115*^9, {
   3.954758024281746*^9, 3.954758036096319*^9}, 3.9547580746525097`*^9, {
   3.9547582109077053`*^9, 3.954758249530725*^9}, {3.956299197234873*^9, 
   3.9562992014433975`*^9}, {3.9571457470901628`*^9, 
   3.9571457533045483`*^9}, {3.961122718668188*^9, 3.961122777857107*^9}, 
   3.9614129237495327`*^9},
 CellLabel->
  "In[273]:=",ExpressionUUID->"c44d3c99-d821-aa44-a5bf-67b591807924"]
}, Closed]],

Cell[CellGroupData[{

Cell["Properties ", "Section",
 CellChangeTimes->{{3.9464385601246834`*^9, 3.9464385707657948`*^9}, {
  3.9464417172462025`*^9, 
  3.946441726397751*^9}},ExpressionUUID->"2609bf4c-7f5c-314e-a744-\
f86d4be283dd"],

Cell[BoxData[
 GraphicsBox[
  TagBox[RasterBox[CompressedData["
1:eJztnQlcVNX7/2f8V+qrSf/UX3/5/WpaRBk/zAItISvIVNQQNXELcUeFXNAU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    "], {{0, 98.49056603773585}, {668.3773584905659, 0}}, {0, 255},
    ColorFunction->RGBColor,
    ImageResolution->{106., 106.},
    RasterInterpolation->"High"],
   BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
   Selectable->False],
  DefaultBaseStyle->"ImageGraphics",
  ImageSize->Automatic,
  ImageSizeRaw->{668.3773584905659, 98.49056603773585},
  PlotRange->{{0, 668.3773584905659}, {0, 98.49056603773585}}]], "Text",
 CellChangeTimes->{3.9547289833023987`*^9, 3.9547318536950836`*^9, 
  3.95474566857682*^9, 
  3.956988661169565*^9},ExpressionUUID->"27562332-302c-684c-a6e9-\
c7f5988655e4"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ptE", "=", 
  RowBox[{"SteinerPoint", "[", 
   RowBox[{"{", 
    RowBox[{"ptA", ",", "ptB", ",", "ptC", ",", "ptD"}], "}"}], "]"}], " ", 
  RowBox[{"(*", 
   RowBox[{"Steiner", " ", "point", " ", "of", " ", "ABCD"}], 
   "*)"}]}]], "Input",
 CellChangeTimes->{{3.954729517411064*^9, 3.954729545606804*^9}, {
  3.954745534742643*^9, 3.954745542313005*^9}, {3.954756841827467*^9, 
  3.954756852715332*^9}},
 CellLabel->
  "In[282]:=",ExpressionUUID->"92df2acf-ef77-6d4c-a144-72124269f2b6"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{"-", 
     SuperscriptBox["b", "4"]}], "+", 
    RowBox[{
     SuperscriptBox["b", "2"], " ", 
     SuperscriptBox["c", "2"]}], "-", 
    RowBox[{
     SuperscriptBox["a", "2"], " ", 
     RowBox[{"(", 
      RowBox[{
       SuperscriptBox["b", "2"], "-", 
       RowBox[{"2", " ", "S"}]}], ")"}]}], "-", 
    RowBox[{"2", " ", 
     SuperscriptBox["c", "2"], " ", "S"}]}], ",", 
   RowBox[{"2", " ", 
    SuperscriptBox["b", "2"], " ", 
    RowBox[{"(", 
     RowBox[{
      SuperscriptBox["b", "2"], "-", 
      RowBox[{"2", " ", "S"}]}], ")"}]}], ",", 
   RowBox[{
    RowBox[{"-", 
     SuperscriptBox["b", "4"]}], "-", 
    RowBox[{
     SuperscriptBox["b", "2"], " ", 
     SuperscriptBox["c", "2"]}], "+", 
    RowBox[{
     SuperscriptBox["a", "2"], " ", 
     RowBox[{"(", 
      RowBox[{
       SuperscriptBox["b", "2"], "-", 
       RowBox[{"2", " ", "S"}]}], ")"}]}], "+", 
    RowBox[{"2", " ", 
     SuperscriptBox["c", "2"], " ", "S"}]}]}], "}"}]], "Output",
 CellChangeTimes->{{3.954729538170908*^9, 3.954729546305495*^9}, {
   3.954731913690204*^9, 3.95473193251383*^9}, 3.954732664086674*^9, 
   3.9547328949279785`*^9, 3.9547455432079754`*^9, 3.9547575036860466`*^9, 
   3.955530247831159*^9, 3.9562993012268963`*^9, 3.9611227895247707`*^9, 
   3.961123039660858*^9, 3.961412945339082*^9},
 CellLabel->
  "Out[282]=",ExpressionUUID->"e69dcba2-5ff8-43be-addc-2f093bd70f3c"]
}, Open  ]],

Cell[CellGroupData[{

Cell["X (486)", "Subsection",
 CellChangeTimes->{{3.9547318899015656`*^9, 3.954731893974074*^9}, {
   3.95473265785647*^9, 3.954732659663503*^9}, {3.954732890679308*^9, 
   3.954732891487614*^9}, 3.954733054504549*^9, 3.954734909088499*^9, {
   3.9547456826790233`*^9, 3.954745683267832*^9}, {3.954746186388487*^9, 
   3.9547461864024734`*^9}, {3.9547472494340367`*^9, 
   3.9547472496864853`*^9}},ExpressionUUID->"b06d3d7c-fd07-4143-89eb-\
4262fe6db97f"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"X486", "=", 
  RowBox[{"Simplificar", "[", 
   RowBox[{
    RowBox[{"Expand", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"ETC", "[", 
        RowBox[{"[", 
         RowBox[{"486", ",", "2"}], "]"}], "]"}], "/.", "sustS"}], "/.", 
      "sustC"}], "]"}], "/.", "sustS"}], "]"}]}]], "Input",
 CellChangeTimes->{{3.954747610010666*^9, 3.954747684007263*^9}, {
  3.9611227990697193`*^9, 3.9611228017341156`*^9}},
 CellLabel->
  "In[283]:=",ExpressionUUID->"8a80128a-ca1a-0843-a2a0-a916a2c41a68"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{"-", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["b", "2"], "-", 
        SuperscriptBox["c", "2"]}], ")"}], "2"]}], "+", 
    RowBox[{
     SuperscriptBox["a", "2"], " ", 
     RowBox[{"(", 
      RowBox[{
       SuperscriptBox["b", "2"], "+", 
       SuperscriptBox["c", "2"], "-", 
       RowBox[{"2", " ", "S"}]}], ")"}]}]}], ",", 
   RowBox[{
    RowBox[{"-", 
     SuperscriptBox["a", "4"]}], "-", 
    SuperscriptBox["c", "4"], "+", 
    RowBox[{
     SuperscriptBox["a", "2"], " ", 
     RowBox[{"(", 
      RowBox[{
       SuperscriptBox["b", "2"], "+", 
       RowBox[{"2", " ", 
        SuperscriptBox["c", "2"]}]}], ")"}]}], "+", 
    RowBox[{
     SuperscriptBox["b", "2"], " ", 
     RowBox[{"(", 
      RowBox[{
       SuperscriptBox["c", "2"], "-", 
       RowBox[{"2", " ", "S"}]}], ")"}]}]}], ",", 
   RowBox[{
    RowBox[{"-", 
     SuperscriptBox["a", "4"]}], "-", 
    SuperscriptBox["b", "4"], "+", 
    RowBox[{
     SuperscriptBox["b", "2"], " ", 
     SuperscriptBox["c", "2"]}], "+", 
    RowBox[{
     SuperscriptBox["a", "2"], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"2", " ", 
        SuperscriptBox["b", "2"]}], "+", 
       SuperscriptBox["c", "2"]}], ")"}]}], "-", 
    RowBox[{"2", " ", 
     SuperscriptBox["c", "2"], " ", "S"}]}]}], "}"}]], "Output",
 CellChangeTimes->{
  3.954747619393961*^9, {3.9547476554628716`*^9, 3.9547476846845*^9}, 
   3.9547583570794487`*^9, 3.9555302639639206`*^9, 3.961122812787937*^9, 
   3.96112304134219*^9, 3.961412945383412*^9},
 CellLabel->
  "Out[283]=",ExpressionUUID->"f97083a2-a7c3-4eaf-9ccf-24156358a766"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"{", 
    RowBox[{"ptF", ",", "ptG", ",", "ptH", ",", "ptI"}], "}"}], "=", 
   RowBox[{"Simplificar", "/@", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       RowBox[{"centralQuadrilateral", "[", 
        RowBox[{"X486", ",", "ptE"}], "]"}], "/.", "sustS"}], "/.", "sustC"}],
      ")"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"{", 
   RowBox[{"ptF", ",", "ptG", ",", "ptH", ",", "ptI"}], "}"}], "=", 
  RowBox[{
   RowBox[{
    RowBox[{"Simplificar", "[", 
     RowBox[{
      RowBox[{"Expand", "[", "#", "]"}], "/.", "sustS"}], "]"}], "&"}], "/@", 
   RowBox[{"{", 
    RowBox[{"ptF", ",", "ptG", ",", "ptH", ",", "ptI"}], "}"}]}]}]}], "Input",
 CellChangeTimes->{{3.954734614817431*^9, 3.954734615601975*^9}, 
   3.954745698225521*^9, {3.954746220639621*^9, 3.954746220703642*^9}, {
   3.954747257081831*^9, 3.954747257656212*^9}, {3.9547476915928345`*^9, 
   3.954747692511669*^9}, {3.954758099553793*^9, 3.954758117861986*^9}, {
   3.9611228072702675`*^9, 3.9611228098308487`*^9}},
 CellLabel->
  "In[284]:=",ExpressionUUID->"da306cb6-cdbd-b447-9da5-a1d78f32c355"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["a", "2"], "-", 
          SuperscriptBox["b", "2"], "-", 
          SuperscriptBox["c", "2"]}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["a", "6"], "-", 
          RowBox[{
           SuperscriptBox["a", "4"], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"2", " ", 
              SuperscriptBox["b", "2"]}], "+", 
             RowBox[{"3", " ", 
              SuperscriptBox["c", "2"]}]}], ")"}]}], "+", 
          RowBox[{
           SuperscriptBox["a", "2"], " ", 
           RowBox[{"(", 
            RowBox[{
             SuperscriptBox["b", "4"], "+", 
             RowBox[{"3", " ", 
              SuperscriptBox["c", "4"]}], "+", 
             RowBox[{"2", " ", 
              SuperscriptBox["b", "2"], " ", "S"}]}], ")"}]}], "-", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{
             SuperscriptBox["b", "2"], "-", 
             SuperscriptBox["c", "2"]}], ")"}], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", 
              SuperscriptBox["c", "4"]}], "+", 
             RowBox[{
              SuperscriptBox["b", "2"], " ", 
              RowBox[{"(", 
               RowBox[{
                SuperscriptBox["c", "2"], "+", 
                RowBox[{"2", " ", "S"}]}], ")"}]}]}], ")"}]}]}], ")"}]}], 
       ")"}]}], ",", 
     RowBox[{
      SuperscriptBox["b", "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"3", " ", 
         SuperscriptBox["a", "6"]}], "+", 
        RowBox[{
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{
            SuperscriptBox["b", "2"], "-", 
            SuperscriptBox["c", "2"]}], ")"}], "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"3", " ", 
            SuperscriptBox["b", "2"]}], "-", 
           RowBox[{"3", " ", 
            SuperscriptBox["c", "2"]}], "-", 
           RowBox[{"2", " ", "S"}]}], ")"}]}], "-", 
        RowBox[{
         SuperscriptBox["a", "4"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"3", " ", 
            SuperscriptBox["b", "2"]}], "+", 
           RowBox[{"9", " ", 
            SuperscriptBox["c", "2"]}], "+", 
           RowBox[{"2", " ", "S"}]}], ")"}]}], "+", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"-", "3"}], " ", 
            SuperscriptBox["b", "4"]}], "+", 
           RowBox[{"9", " ", 
            SuperscriptBox["c", "4"]}], "-", 
           RowBox[{"6", " ", 
            SuperscriptBox["b", "2"], " ", 
            RowBox[{"(", 
             RowBox[{
              SuperscriptBox["c", "2"], "-", 
              RowBox[{"2", " ", "S"}]}], ")"}]}], "+", 
           RowBox[{"4", " ", 
            SuperscriptBox["c", "2"], " ", "S"}]}], ")"}]}]}], ")"}]}], ",", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "2"], "-", 
        SuperscriptBox["b", "2"], "-", 
        SuperscriptBox["c", "2"]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "6"], "+", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "2"], "-", 
           SuperscriptBox["c", "2"]}], ")"}], "3"], "-", 
        RowBox[{
         SuperscriptBox["a", "4"], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "2"], "+", 
           RowBox[{"3", " ", 
            SuperscriptBox["c", "2"]}]}], ")"}]}], "-", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "4"], "-", 
           RowBox[{"3", " ", 
            SuperscriptBox["c", "4"]}], "+", 
           RowBox[{"2", " ", 
            SuperscriptBox["b", "2"], " ", 
            RowBox[{"(", 
             RowBox[{
              SuperscriptBox["c", "2"], "-", 
              RowBox[{"2", " ", "S"}]}], ")"}]}]}], ")"}]}]}], ")"}]}]}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "2"], "+", 
        SuperscriptBox["b", "2"], "-", 
        SuperscriptBox["c", "2"]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "6"], "-", 
        SuperscriptBox["b", "6"], "+", 
        RowBox[{
         SuperscriptBox["b", "4"], " ", 
         SuperscriptBox["c", "2"]}], "-", 
        SuperscriptBox["c", "6"], "-", 
        RowBox[{"3", " ", 
         SuperscriptBox["a", "4"], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "2"], "+", 
           SuperscriptBox["c", "2"]}], ")"}]}], "+", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"3", " ", 
            SuperscriptBox["b", "4"]}], "+", 
           RowBox[{"2", " ", 
            SuperscriptBox["b", "2"], " ", 
            SuperscriptBox["c", "2"]}], "+", 
           RowBox[{"3", " ", 
            SuperscriptBox["c", "4"]}]}], ")"}]}], "+", 
        RowBox[{
         SuperscriptBox["b", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["c", "4"], "-", 
           RowBox[{"4", " ", 
            SuperscriptBox["c", "2"], " ", "S"}]}], ")"}]}]}], ")"}]}], ",", 
     RowBox[{
      SuperscriptBox["b", "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"-", "3"}], " ", 
         SuperscriptBox["a", "6"]}], "+", 
        RowBox[{"3", " ", 
         SuperscriptBox["b", "6"]}], "+", 
        RowBox[{"3", " ", 
         SuperscriptBox["c", "6"]}], "+", 
        RowBox[{
         SuperscriptBox["a", "4"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"9", " ", 
            SuperscriptBox["b", "2"]}], "+", 
           RowBox[{"9", " ", 
            SuperscriptBox["c", "2"]}], "-", 
           RowBox[{"2", " ", "S"}]}], ")"}]}], "-", 
        RowBox[{"2", " ", 
         SuperscriptBox["c", "4"], " ", "S"}], "-", 
        RowBox[{
         SuperscriptBox["b", "4"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"3", " ", 
            SuperscriptBox["c", "2"]}], "+", 
           RowBox[{"2", " ", "S"}]}], ")"}]}], "-", 
        RowBox[{"3", " ", 
         SuperscriptBox["b", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["c", "4"], "-", 
           RowBox[{"4", " ", 
            SuperscriptBox["c", "2"], " ", "S"}]}], ")"}]}], "+", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"-", "9"}], " ", 
            SuperscriptBox["b", "4"]}], "-", 
           RowBox[{"9", " ", 
            SuperscriptBox["c", "4"]}], "+", 
           RowBox[{"4", " ", 
            SuperscriptBox["c", "2"], " ", "S"}], "+", 
           RowBox[{
            SuperscriptBox["b", "2"], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               RowBox[{"-", "6"}], " ", 
               SuperscriptBox["c", "2"]}], "+", 
              RowBox[{"4", " ", "S"}]}], ")"}]}]}], ")"}]}]}], ")"}]}], ",", 
     RowBox[{"-", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["a", "2"], "+", 
          SuperscriptBox["b", "2"], "-", 
          SuperscriptBox["c", "2"]}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["a", "6"], "-", 
          RowBox[{
           SuperscriptBox["a", "4"], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"2", " ", 
              SuperscriptBox["b", "2"]}], "+", 
             RowBox[{"3", " ", 
              SuperscriptBox["c", "2"]}]}], ")"}]}], "-", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{
             SuperscriptBox["b", "2"], "-", 
             SuperscriptBox["c", "2"]}], ")"}], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", 
              SuperscriptBox["c", "4"]}], "+", 
             RowBox[{
              SuperscriptBox["b", "2"], " ", 
              RowBox[{"(", 
               RowBox[{
                SuperscriptBox["c", "2"], "-", 
                RowBox[{"2", " ", "S"}]}], ")"}]}]}], ")"}]}], "+", 
          RowBox[{
           SuperscriptBox["a", "2"], " ", 
           RowBox[{"(", 
            RowBox[{
             SuperscriptBox["b", "4"], "+", 
             RowBox[{"3", " ", 
              SuperscriptBox["c", "4"]}], "-", 
             RowBox[{"2", " ", 
              SuperscriptBox["b", "2"], " ", "S"}]}], ")"}]}]}], ")"}]}], 
       ")"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "2"], "+", 
        SuperscriptBox["b", "2"], "-", 
        SuperscriptBox["c", "2"]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         SuperscriptBox["a", "6"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"5", " ", 
            SuperscriptBox["b", "2"]}], "-", 
           RowBox[{"2", " ", "S"}]}], ")"}]}], "+", 
        RowBox[{
         SuperscriptBox["a", "4"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"-", "5"}], " ", 
            SuperscriptBox["b", "4"]}], "-", 
           RowBox[{"13", " ", 
            SuperscriptBox["b", "2"], " ", 
            SuperscriptBox["c", "2"]}], "+", 
           RowBox[{"6", " ", 
            SuperscriptBox["c", "2"], " ", "S"}]}], ")"}]}], "+", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "2"], "-", 
           SuperscriptBox["c", "2"]}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"5", " ", 
            SuperscriptBox["b", "6"]}], "-", 
           RowBox[{"8", " ", 
            SuperscriptBox["b", "4"], " ", 
            SuperscriptBox["c", "2"]}], "-", 
           RowBox[{"2", " ", 
            SuperscriptBox["c", "4"], " ", "S"}], "+", 
           RowBox[{"3", " ", 
            SuperscriptBox["b", "2"], " ", 
            RowBox[{"(", 
             RowBox[{
              SuperscriptBox["c", "4"], "+", 
              RowBox[{"2", " ", 
               SuperscriptBox["c", "2"], " ", "S"}]}], ")"}]}]}], ")"}]}], "+", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"-", "5"}], " ", 
            SuperscriptBox["b", "6"]}], "-", 
           RowBox[{"2", " ", 
            SuperscriptBox["b", "4"], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"7", " ", 
               SuperscriptBox["c", "2"]}], "-", 
              RowBox[{"9", " ", "S"}]}], ")"}]}], "-", 
           RowBox[{"6", " ", 
            SuperscriptBox["c", "4"], " ", "S"}], "+", 
           RowBox[{
            SuperscriptBox["b", "2"], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"11", " ", 
               SuperscriptBox["c", "4"]}], "+", 
              RowBox[{"8", " ", 
               SuperscriptBox["c", "2"], " ", "S"}]}], ")"}]}]}], ")"}]}]}], 
       ")"}]}], ",", 
     RowBox[{
      SuperscriptBox["b", "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "8"], "-", 
        RowBox[{"2", " ", 
         SuperscriptBox["a", "6"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"8", " ", 
            SuperscriptBox["b", "2"]}], "+", 
           RowBox[{"2", " ", 
            SuperscriptBox["c", "2"]}], "-", 
           RowBox[{"3", " ", "S"}]}], ")"}]}], "+", 
        RowBox[{"2", " ", 
         SuperscriptBox["a", "4"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"9", " ", 
            SuperscriptBox["b", "4"]}], "+", 
           RowBox[{"3", " ", 
            SuperscriptBox["c", "2"], " ", 
            RowBox[{"(", 
             RowBox[{
              SuperscriptBox["c", "2"], "-", 
              RowBox[{"3", " ", "S"}]}], ")"}]}], "+", 
           RowBox[{
            SuperscriptBox["b", "2"], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"18", " ", 
               SuperscriptBox["c", "2"]}], "+", "S"}], ")"}]}]}], ")"}]}], "-", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "2"], "-", 
           SuperscriptBox["c", "2"]}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"11", " ", 
            SuperscriptBox["b", "6"]}], "+", 
           SuperscriptBox["c", "6"], "-", 
           RowBox[{"6", " ", 
            SuperscriptBox["c", "4"], " ", "S"}], "-", 
           RowBox[{
            SuperscriptBox["b", "4"], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"17", " ", 
               SuperscriptBox["c", "2"]}], "+", 
              RowBox[{"6", " ", "S"}]}], ")"}]}], "+", 
           RowBox[{"5", " ", 
            SuperscriptBox["b", "2"], " ", 
            RowBox[{"(", 
             RowBox[{
              SuperscriptBox["c", "4"], "+", 
              RowBox[{"4", " ", 
               SuperscriptBox["c", "2"], " ", "S"}]}], ")"}]}]}], ")"}]}], "+", 
        RowBox[{"2", " ", 
         SuperscriptBox["a", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"4", " ", 
            SuperscriptBox["b", "6"]}], "-", 
           RowBox[{"2", " ", 
            SuperscriptBox["c", "6"]}], "+", 
           RowBox[{
            SuperscriptBox["b", "4"], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"18", " ", 
               SuperscriptBox["c", "2"]}], "-", 
              RowBox[{"23", " ", "S"}]}], ")"}]}], "+", 
           RowBox[{"9", " ", 
            SuperscriptBox["c", "4"], " ", "S"}], "-", 
           RowBox[{"2", " ", 
            SuperscriptBox["b", "2"], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"6", " ", 
               SuperscriptBox["c", "4"]}], "+", 
              RowBox[{"7", " ", 
               SuperscriptBox["c", "2"], " ", "S"}]}], ")"}]}]}], ")"}]}]}], 
       ")"}]}], ",", 
     RowBox[{
      RowBox[{"-", "2"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         SuperscriptBox["a", "8"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"3", " ", 
            SuperscriptBox["b", "2"]}], "-", "S"}], ")"}]}], "-", 
        RowBox[{
         SuperscriptBox["a", "6"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"3", " ", 
            SuperscriptBox["b", "4"]}], "-", 
           RowBox[{"4", " ", 
            SuperscriptBox["c", "2"], " ", "S"}], "+", 
           RowBox[{
            SuperscriptBox["b", "2"], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"11", " ", 
               SuperscriptBox["c", "2"]}], "+", 
              RowBox[{"2", " ", "S"}]}], ")"}]}]}], ")"}]}], "+", 
        RowBox[{
         SuperscriptBox["a", "4"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"-", "5"}], " ", 
            SuperscriptBox["b", "6"]}], "-", 
           RowBox[{"4", " ", 
            SuperscriptBox["b", "4"], " ", 
            RowBox[{"(", 
             RowBox[{
              SuperscriptBox["c", "2"], "-", 
              RowBox[{"3", " ", "S"}]}], ")"}]}], "-", 
           RowBox[{"6", " ", 
            SuperscriptBox["c", "4"], " ", "S"}], "+", 
           RowBox[{"5", " ", 
            SuperscriptBox["b", "2"], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"3", " ", 
               SuperscriptBox["c", "4"]}], "+", 
              RowBox[{"2", " ", 
               SuperscriptBox["c", "2"], " ", "S"}]}], ")"}]}]}], ")"}]}], "-", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "2"], "-", 
           SuperscriptBox["c", "2"]}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"2", " ", 
            SuperscriptBox["b", "8"]}], "+", 
           RowBox[{"3", " ", 
            SuperscriptBox["b", "6"], " ", "S"}], "-", 
           RowBox[{
            SuperscriptBox["c", "6"], " ", "S"}], "-", 
           RowBox[{
            SuperscriptBox["b", "4"], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"4", " ", 
               SuperscriptBox["c", "4"]}], "+", 
              RowBox[{"3", " ", 
               SuperscriptBox["c", "2"], " ", "S"}]}], ")"}]}], "+", 
           RowBox[{
            SuperscriptBox["b", "2"], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"2", " ", 
               SuperscriptBox["c", "6"]}], "+", 
              RowBox[{"5", " ", 
               SuperscriptBox["c", "4"], " ", "S"}]}], ")"}]}]}], ")"}]}], "+", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"7", " ", 
            SuperscriptBox["b", "8"]}], "+", 
           RowBox[{"4", " ", 
            SuperscriptBox["c", "6"], " ", "S"}], "-", 
           RowBox[{"3", " ", 
            SuperscriptBox["b", "6"], " ", 
            RowBox[{"(", 
             RowBox[{
              SuperscriptBox["c", "2"], "+", 
              RowBox[{"2", " ", "S"}]}], ")"}]}], "+", 
           RowBox[{
            SuperscriptBox["b", "4"], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"13", " ", 
               SuperscriptBox["c", "4"]}], "-", 
              RowBox[{"4", " ", 
               SuperscriptBox["c", "2"], " ", "S"}]}], ")"}]}], "-", 
           RowBox[{
            SuperscriptBox["b", "2"], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"9", " ", 
               SuperscriptBox["c", "6"]}], "+", 
              RowBox[{"14", " ", 
               SuperscriptBox["c", "4"], " ", "S"}]}], ")"}]}]}], ")"}]}]}], 
       ")"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "2"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         SuperscriptBox["a", "8"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"2", " ", 
            SuperscriptBox["b", "2"]}], "-", "S"}], ")"}]}], "+", 
        RowBox[{
         SuperscriptBox["a", "6"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"-", "6"}], " ", 
            SuperscriptBox["b", "4"]}], "+", 
           RowBox[{"4", " ", 
            SuperscriptBox["c", "2"], " ", "S"}], "+", 
           RowBox[{
            SuperscriptBox["b", "2"], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               RowBox[{"-", "9"}], " ", 
               SuperscriptBox["c", "2"]}], "+", 
              RowBox[{"6", " ", "S"}]}], ")"}]}]}], ")"}]}], "+", 
        RowBox[{
         SuperscriptBox["a", "4"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"4", " ", 
            SuperscriptBox["b", "6"]}], "+", 
           RowBox[{
            SuperscriptBox["b", "4"], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"13", " ", 
               SuperscriptBox["c", "2"]}], "-", 
              RowBox[{"8", " ", "S"}]}], ")"}]}], "-", 
           RowBox[{"6", " ", 
            SuperscriptBox["c", "4"], " ", "S"}], "+", 
           RowBox[{
            SuperscriptBox["b", "2"], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"15", " ", 
               SuperscriptBox["c", "4"]}], "-", 
              RowBox[{"14", " ", 
               SuperscriptBox["c", "2"], " ", "S"}]}], ")"}]}]}], ")"}]}], "-", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "2"], "-", 
           SuperscriptBox["c", "2"]}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"2", " ", 
            SuperscriptBox["b", "8"]}], "+", 
           RowBox[{"9", " ", 
            SuperscriptBox["b", "4"], " ", 
            SuperscriptBox["c", "2"], " ", "S"}], "-", 
           RowBox[{
            SuperscriptBox["c", "6"], " ", "S"}], "+", 
           RowBox[{
            SuperscriptBox["b", "6"], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               RowBox[{"-", "5"}], " ", 
               SuperscriptBox["c", "2"]}], "+", 
              RowBox[{"3", " ", "S"}]}], ")"}]}], "+", 
           RowBox[{"3", " ", 
            SuperscriptBox["b", "2"], " ", 
            RowBox[{"(", 
             RowBox[{
              SuperscriptBox["c", "6"], "-", 
              RowBox[{
               SuperscriptBox["c", "4"], " ", "S"}]}], ")"}]}]}], ")"}]}], "+", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"2", " ", 
            SuperscriptBox["b", "8"]}], "-", 
           RowBox[{"3", " ", 
            SuperscriptBox["b", "6"], " ", 
            RowBox[{"(", 
             RowBox[{
              SuperscriptBox["c", "2"], "-", 
              RowBox[{"2", " ", "S"}]}], ")"}]}], "+", 
           RowBox[{"4", " ", 
            SuperscriptBox["c", "6"], " ", "S"}], "-", 
           RowBox[{"4", " ", 
            SuperscriptBox["b", "4"], " ", 
            SuperscriptBox["c", "2"], " ", 
            RowBox[{"(", 
             RowBox[{
              SuperscriptBox["c", "2"], "+", "S"}], ")"}]}], "+", 
           RowBox[{
            SuperscriptBox["b", "2"], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               RowBox[{"-", "11"}], " ", 
               SuperscriptBox["c", "6"]}], "+", 
              RowBox[{"10", " ", 
               SuperscriptBox["c", "4"], " ", "S"}]}], ")"}]}]}], ")"}]}]}], 
       ")"}]}], ",", 
     RowBox[{
      SuperscriptBox["b", "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "8"], "-", 
        RowBox[{"11", " ", 
         SuperscriptBox["b", "8"]}], "+", 
        SuperscriptBox["c", "8"], "+", 
        RowBox[{
         SuperscriptBox["a", "6"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"4", " ", 
            SuperscriptBox["b", "2"]}], "-", 
           RowBox[{"4", " ", 
            SuperscriptBox["c", "2"]}], "-", 
           RowBox[{"6", " ", "S"}]}], ")"}]}], "+", 
        RowBox[{"6", " ", 
         SuperscriptBox["c", "6"], " ", "S"}], "+", 
        RowBox[{"2", " ", 
         SuperscriptBox["b", "2"], " ", 
         SuperscriptBox["c", "4"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"-", "8"}], " ", 
            SuperscriptBox["c", "2"]}], "+", "S"}], ")"}]}], "+", 
        RowBox[{
         SuperscriptBox["b", "6"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"8", " ", 
            SuperscriptBox["c", "2"]}], "+", 
           RowBox[{"6", " ", "S"}]}], ")"}]}], "+", 
        RowBox[{"2", " ", 
         SuperscriptBox["b", "4"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"9", " ", 
            SuperscriptBox["c", "4"]}], "-", 
           RowBox[{"23", " ", 
            SuperscriptBox["c", "2"], " ", "S"}]}], ")"}]}], "+", 
        RowBox[{"2", " ", 
         SuperscriptBox["a", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"14", " ", 
            SuperscriptBox["b", "6"]}], "-", 
           RowBox[{"2", " ", 
            SuperscriptBox["c", "6"]}], "+", 
           RowBox[{
            SuperscriptBox["b", "4"], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"18", " ", 
               SuperscriptBox["c", "2"]}], "-", 
              RowBox[{"13", " ", "S"}]}], ")"}]}], "-", 
           RowBox[{"9", " ", 
            SuperscriptBox["c", "4"], " ", "S"}], "+", 
           RowBox[{"2", " ", 
            SuperscriptBox["b", "2"], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"9", " ", 
               SuperscriptBox["c", "4"]}], "-", 
              RowBox[{"7", " ", 
               SuperscriptBox["c", "2"], " ", "S"}]}], ")"}]}]}], ")"}]}], "+", 
        RowBox[{
         SuperscriptBox["a", "4"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"-", "22"}], " ", 
            SuperscriptBox["b", "4"]}], "+", 
           RowBox[{
            SuperscriptBox["b", "2"], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               RowBox[{"-", "24"}], " ", 
               SuperscriptBox["c", "2"]}], "+", 
              RowBox[{"26", " ", "S"}]}], ")"}]}], "+", 
           RowBox[{"6", " ", 
            RowBox[{"(", 
             RowBox[{
              SuperscriptBox["c", "4"], "+", 
              RowBox[{"3", " ", 
               SuperscriptBox["c", "2"], " ", "S"}]}], ")"}]}]}], ")"}]}]}], 
       ")"}]}], ",", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "2"], "-", 
        SuperscriptBox["b", "2"], "-", 
        SuperscriptBox["c", "2"]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"-", "5"}], " ", 
         SuperscriptBox["b", "8"]}], "+", 
        RowBox[{"5", " ", 
         SuperscriptBox["b", "6"], " ", 
         SuperscriptBox["c", "2"]}], "-", 
        RowBox[{"5", " ", 
         SuperscriptBox["b", "2"], " ", 
         SuperscriptBox["c", "6"]}], "+", 
        RowBox[{
         SuperscriptBox["a", "6"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"3", " ", 
            SuperscriptBox["b", "2"]}], "-", 
           RowBox[{"2", " ", "S"}]}], ")"}]}], "+", 
        RowBox[{"2", " ", 
         SuperscriptBox["c", "6"], " ", "S"}], "+", 
        RowBox[{
         SuperscriptBox["b", "4"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"5", " ", 
            SuperscriptBox["c", "4"]}], "-", 
           RowBox[{"18", " ", 
            SuperscriptBox["c", "2"], " ", "S"}]}], ")"}]}], "+", 
        RowBox[{
         SuperscriptBox["a", "4"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"-", "11"}], " ", 
            SuperscriptBox["b", "4"]}], "+", 
           RowBox[{"6", " ", 
            SuperscriptBox["c", "2"], " ", "S"}], "+", 
           RowBox[{
            SuperscriptBox["b", "2"], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               RowBox[{"-", "11"}], " ", 
               SuperscriptBox["c", "2"]}], "+", 
              RowBox[{"8", " ", "S"}]}], ")"}]}]}], ")"}]}], "+", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"13", " ", 
            SuperscriptBox["b", "6"]}], "+", 
           RowBox[{"2", " ", 
            SuperscriptBox["b", "4"], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"7", " ", 
               SuperscriptBox["c", "2"]}], "-", 
              RowBox[{"3", " ", "S"}]}], ")"}]}], "-", 
           RowBox[{"6", " ", 
            SuperscriptBox["c", "4"], " ", "S"}], "+", 
           RowBox[{
            SuperscriptBox["b", "2"], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"13", " ", 
               SuperscriptBox["c", "4"]}], "-", 
              RowBox[{"8", " ", 
               SuperscriptBox["c", "2"], " ", "S"}]}], ")"}]}]}], ")"}]}]}], 
       ")"}]}]}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{3.954734617198675*^9, 3.954734816513953*^9, 
  3.9547348978013396`*^9, 3.954745620213978*^9, 3.954745705154098*^9, 
  3.954746221829569*^9, 3.954747260051348*^9, 3.954747694515775*^9, 
  3.9547581196008153`*^9, 3.9547583599511127`*^9, 3.9555302652502193`*^9, 
  3.96112282459227*^9, 3.961123046153097*^9, 3.961412948276718*^9},
 CellLabel->
  "Out[285]=",ExpressionUUID->"8e593f59-5730-4fb4-a86a-8c51e827c60a"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"orthodiagonalQuadQ", "[", 
  RowBox[{"{", 
   RowBox[{"ptF", ",", "ptG", ",", "ptH", ",", "ptI"}], "}"}], "]"}]], "Input",
 CellChangeTimes->{{3.954758160947884*^9, 3.954758162349493*^9}},
 CellLabel->
  "In[286]:=",ExpressionUUID->"78b6f02c-d7d8-a344-8ead-13ac4448af8f"],

Cell[BoxData["True"], "Output",
 CellChangeTimes->{3.954758166997286*^9, 3.954758265104833*^9, 
  3.95475831942744*^9, 3.954758366168917*^9, 3.9555302671952076`*^9, 
  3.961122949315998*^9, 3.9611230529680004`*^9, 3.961412952406877*^9},
 CellLabel->
  "Out[286]=",ExpressionUUID->"a26cf30f-d129-44e7-9c91-dfcb62ad7ad1"]
}, Open  ]],

Cell["The  diagonals of FGHI meet at point E", "Text",
 CellChangeTimes->{{3.955530274005833*^9, 3.955530286428717*^9}, 
   3.961122861033678*^9, {3.9611230898130264`*^9, 
   3.961123092180998*^9}},ExpressionUUID->"b5a79090-5d8a-664b-a76e-\
251c2479c317"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ptQ", "=", 
  RowBox[{"Simplificar", "[", 
   RowBox[{
    RowBox[{"Expand", "[", 
     RowBox[{"Punto", "[", 
      RowBox[{
       RowBox[{"Recta", "[", 
        RowBox[{"ptF", ",", "ptH"}], "]"}], ",", 
       RowBox[{"Recta", "[", 
        RowBox[{"ptG", ",", "ptI"}], "]"}]}], "]"}], "]"}], "/.", "sustS"}], 
   "]"}]}]], "Input",
 CellChangeTimes->{{3.95553029237756*^9, 3.955530350677897*^9}},
 CellLabel->
  "In[287]:=",ExpressionUUID->"a652668f-bd5f-9f4a-a808-374b5c50170f"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{"9", " ", 
     SuperscriptBox["a", "18"], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"5", " ", 
        SuperscriptBox["b", "2"]}], "-", 
       RowBox[{"2", " ", "S"}]}], ")"}]}], "+", 
    RowBox[{
     SuperscriptBox["a", "16"], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        RowBox[{"-", "197"}], " ", 
        SuperscriptBox["b", "4"]}], "-", 
       RowBox[{"9", " ", 
        SuperscriptBox["b", "2"], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"45", " ", 
           SuperscriptBox["c", "2"]}], "-", 
          RowBox[{"8", " ", "S"}]}], ")"}]}], "+", 
       RowBox[{"162", " ", 
        SuperscriptBox["c", "2"], " ", "S"}]}], ")"}]}], "+", 
    RowBox[{"12", " ", 
     SuperscriptBox["a", "14"], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"21", " ", 
        SuperscriptBox["b", "6"]}], "-", 
       RowBox[{"54", " ", 
        SuperscriptBox["c", "4"], " ", "S"}], "+", 
       RowBox[{
        SuperscriptBox["b", "4"], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"97", " ", 
           SuperscriptBox["c", "2"]}], "+", 
          RowBox[{"6", " ", "S"}]}], ")"}]}], "+", 
       RowBox[{"9", " ", 
        SuperscriptBox["b", "2"], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"15", " ", 
           SuperscriptBox["c", "4"]}], "-", 
          RowBox[{"4", " ", 
           SuperscriptBox["c", "2"], " ", "S"}]}], ")"}]}]}], ")"}]}], "-", 
    RowBox[{"4", " ", 
     SuperscriptBox["a", "12"], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"7", " ", 
        SuperscriptBox["b", "8"]}], "-", 
       RowBox[{"378", " ", 
        SuperscriptBox["c", "6"], " ", "S"}], "+", 
       RowBox[{"8", " ", 
        SuperscriptBox["b", "6"], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"17", " ", 
           SuperscriptBox["c", "2"]}], "+", 
          RowBox[{"13", " ", "S"}]}], ")"}]}], "+", 
       RowBox[{"14", " ", 
        SuperscriptBox["b", "4"], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"47", " ", 
           SuperscriptBox["c", "4"]}], "+", 
          RowBox[{"16", " ", 
           SuperscriptBox["c", "2"], " ", "S"}]}], ")"}]}], "+", 
       RowBox[{"63", " ", 
        SuperscriptBox["b", "2"], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"15", " ", 
           SuperscriptBox["c", "6"]}], "-", 
          RowBox[{"4", " ", 
           SuperscriptBox["c", "4"], " ", "S"}]}], ")"}]}]}], ")"}]}], "+", 
    RowBox[{"2", " ", 
     SuperscriptBox["a", "8"], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"33", " ", 
        SuperscriptBox["b", "12"]}], "-", 
       RowBox[{"2835", " ", 
        SuperscriptBox["b", "2"], " ", 
        SuperscriptBox["c", "10"]}], "+", 
       RowBox[{
        SuperscriptBox["b", "10"], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"147", " ", 
           SuperscriptBox["c", "2"]}], "-", 
          RowBox[{"40", " ", "S"}]}], ")"}]}], "+", 
       RowBox[{"1134", " ", 
        SuperscriptBox["c", "10"], " ", "S"}], "+", 
       RowBox[{"2", " ", 
        SuperscriptBox["b", "8"], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"165", " ", 
           SuperscriptBox["c", "4"]}], "-", 
          RowBox[{"59", " ", 
           SuperscriptBox["c", "2"], " ", "S"}]}], ")"}]}], "+", 
       RowBox[{"2", " ", 
        SuperscriptBox["b", "6"], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"755", " ", 
           SuperscriptBox["c", "6"]}], "-", 
          RowBox[{"444", " ", 
           SuperscriptBox["c", "4"], " ", "S"}]}], ")"}]}], "+", 
       RowBox[{"35", " ", 
        SuperscriptBox["b", "4"], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"9", " ", 
           SuperscriptBox["c", "8"]}], "-", 
          RowBox[{"92", " ", 
           SuperscriptBox["c", "6"], " ", "S"}]}], ")"}]}]}], ")"}]}], "-", 
    RowBox[{"2", " ", 
     SuperscriptBox["a", "10"], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"69", " ", 
        SuperscriptBox["b", "10"]}], "+", 
       RowBox[{"2", " ", 
        SuperscriptBox["b", "8"], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"121", " ", 
           SuperscriptBox["c", "2"]}], "-", 
          RowBox[{"89", " ", "S"}]}], ")"}]}], "+", 
       RowBox[{"1134", " ", 
        SuperscriptBox["c", "8"], " ", "S"}], "+", 
       RowBox[{"16", " ", 
        SuperscriptBox["b", "6"], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"23", " ", 
           SuperscriptBox["c", "4"]}], "-", 
          RowBox[{"54", " ", 
           SuperscriptBox["c", "2"], " ", "S"}]}], ")"}]}], "-", 
       RowBox[{"14", " ", 
        SuperscriptBox["b", "4"], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"85", " ", 
           SuperscriptBox["c", "6"]}], "+", 
          RowBox[{"124", " ", 
           SuperscriptBox["c", "4"], " ", "S"}]}], ")"}]}], "-", 
       RowBox[{"63", " ", 
        SuperscriptBox["b", "2"], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"45", " ", 
           SuperscriptBox["c", "8"]}], "-", 
          RowBox[{"8", " ", 
           SuperscriptBox["c", "6"], " ", "S"}]}], ")"}]}]}], ")"}]}], "+", 
    RowBox[{
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["b", "2"], "-", 
        SuperscriptBox["c", "2"]}], ")"}], "2"], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"3", " ", 
        SuperscriptBox["b", "16"]}], "+", 
       RowBox[{
        SuperscriptBox["b", "4"], " ", 
        SuperscriptBox["c", "10"], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"125", " ", 
           SuperscriptBox["c", "2"]}], "-", 
          RowBox[{"162", " ", "S"}]}], ")"}]}], "+", 
       RowBox[{
        SuperscriptBox["b", "14"], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"5", " ", 
           SuperscriptBox["c", "2"]}], "-", 
          RowBox[{"8", " ", "S"}]}], ")"}]}], "+", 
       RowBox[{"18", " ", 
        SuperscriptBox["c", "14"], " ", "S"}], "-", 
       RowBox[{"9", " ", 
        SuperscriptBox["b", "2"], " ", 
        SuperscriptBox["c", "12"], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"5", " ", 
           SuperscriptBox["c", "2"]}], "+", 
          RowBox[{"4", " ", "S"}]}], ")"}]}], "+", 
       RowBox[{
        SuperscriptBox["b", "12"], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           RowBox[{"-", "53"}], " ", 
           SuperscriptBox["c", "4"]}], "+", 
          RowBox[{"42", " ", 
           SuperscriptBox["c", "2"], " ", "S"}]}], ")"}]}], "+", 
       RowBox[{
        SuperscriptBox["b", "10"], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"149", " ", 
           SuperscriptBox["c", "6"]}], "-", 
          RowBox[{"52", " ", 
           SuperscriptBox["c", "4"], " ", "S"}]}], ")"}]}], "-", 
       RowBox[{
        SuperscriptBox["b", "8"], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"155", " ", 
           SuperscriptBox["c", "8"]}], "+", 
          RowBox[{"42", " ", 
           SuperscriptBox["c", "6"], " ", "S"}]}], ")"}]}], "+", 
       RowBox[{
        SuperscriptBox["b", "6"], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           RowBox[{"-", "29"}], " ", 
           SuperscriptBox["c", "10"]}], "+", 
          RowBox[{"272", " ", 
           SuperscriptBox["c", "8"], " ", "S"}]}], ")"}]}]}], ")"}]}], "+", 
    RowBox[{"4", " ", 
     SuperscriptBox["a", "6"], " ", 
     RowBox[{"(", 
      RowBox[{
       SuperscriptBox["b", "14"], "-", 
       RowBox[{"378", " ", 
        SuperscriptBox["c", "12"], " ", "S"}], "+", 
       RowBox[{"63", " ", 
        SuperscriptBox["b", "2"], " ", 
        SuperscriptBox["c", "10"], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"15", " ", 
           SuperscriptBox["c", "2"]}], "+", 
          RowBox[{"4", " ", "S"}]}], ")"}]}], "+", 
       RowBox[{
        SuperscriptBox["b", "12"], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           RowBox[{"-", "19"}], " ", 
           SuperscriptBox["c", "2"]}], "+", 
          RowBox[{"10", " ", "S"}]}], ")"}]}], "+", 
       RowBox[{
        SuperscriptBox["b", "10"], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           RowBox[{"-", "29"}], " ", 
           SuperscriptBox["c", "4"]}], "+", 
          RowBox[{"20", " ", 
           SuperscriptBox["c", "2"], " ", "S"}]}], ")"}]}], "+", 
       RowBox[{
        SuperscriptBox["b", "8"], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"294", " ", 
           SuperscriptBox["c", "6"]}], "-", 
          RowBox[{"202", " ", 
           SuperscriptBox["c", "4"], " ", "S"}]}], ")"}]}], "-", 
       RowBox[{"5", " ", 
        SuperscriptBox["b", "6"], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"133", " ", 
           SuperscriptBox["c", "8"]}], "+", 
          RowBox[{"72", " ", 
           SuperscriptBox["c", "6"], " ", "S"}]}], ")"}]}], "+", 
       RowBox[{
        SuperscriptBox["b", "4"], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           RowBox[{"-", "847"}], " ", 
           SuperscriptBox["c", "10"]}], "+", 
          RowBox[{"1610", " ", 
           SuperscriptBox["c", "8"], " ", "S"}]}], ")"}]}]}], ")"}]}], "-", 
    RowBox[{"4", " ", 
     SuperscriptBox["a", "4"], " ", 
     RowBox[{"(", 
      RowBox[{
       SuperscriptBox["b", "16"], "-", 
       RowBox[{"12", " ", 
        SuperscriptBox["b", "14"], " ", 
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["c", "2"], "-", "S"}], ")"}]}], "-", 
       RowBox[{"162", " ", 
        SuperscriptBox["c", "14"], " ", "S"}], "+", 
       RowBox[{"9", " ", 
        SuperscriptBox["b", "2"], " ", 
        SuperscriptBox["c", "12"], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"45", " ", 
           SuperscriptBox["c", "2"]}], "+", 
          RowBox[{"28", " ", "S"}]}], ")"}]}], "-", 
       RowBox[{"2", " ", 
        SuperscriptBox["b", "6"], " ", 
        SuperscriptBox["c", "8"], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"11", " ", 
           SuperscriptBox["c", "2"]}], "+", 
          RowBox[{"492", " ", "S"}]}], ")"}]}], "+", 
       RowBox[{
        SuperscriptBox["b", "12"], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           RowBox[{"-", "14"}], " ", 
           SuperscriptBox["c", "4"]}], "+", 
          RowBox[{"4", " ", 
           SuperscriptBox["c", "2"], " ", "S"}]}], ")"}]}], "+", 
       RowBox[{
        SuperscriptBox["b", "10"], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           RowBox[{"-", "227"}], " ", 
           SuperscriptBox["c", "6"]}], "+", 
          RowBox[{"144", " ", 
           SuperscriptBox["c", "4"], " ", "S"}]}], ")"}]}], "+", 
       RowBox[{
        SuperscriptBox["b", "8"], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"557", " ", 
           SuperscriptBox["c", "8"]}], "-", 
          RowBox[{"6", " ", 
           SuperscriptBox["c", "6"], " ", "S"}]}], ")"}]}], "+", 
       RowBox[{
        SuperscriptBox["b", "4"], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           RowBox[{"-", "784"}], " ", 
           SuperscriptBox["c", "12"]}], "+", 
          RowBox[{"868", " ", 
           SuperscriptBox["c", "10"], " ", "S"}]}], ")"}]}]}], ")"}]}], "+", 
    RowBox[{
     SuperscriptBox["a", "2"], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        RowBox[{"-", "3"}], " ", 
        SuperscriptBox["b", "18"]}], "+", 
       RowBox[{"8", " ", 
        SuperscriptBox["b", "6"], " ", 
        SuperscriptBox["c", "10"], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"113", " ", 
           SuperscriptBox["c", "2"]}], "-", 
          RowBox[{"324", " ", "S"}]}], ")"}]}], "-", 
       RowBox[{"162", " ", 
        SuperscriptBox["c", "16"], " ", "S"}], "+", 
       RowBox[{"30", " ", 
        SuperscriptBox["b", "16"], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           RowBox[{"-", "2"}], " ", 
           SuperscriptBox["c", "2"]}], "+", "S"}], ")"}]}], "+", 
       RowBox[{"27", " ", 
        SuperscriptBox["b", "2"], " ", 
        SuperscriptBox["c", "14"], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"15", " ", 
           SuperscriptBox["c", "2"]}], "+", 
          RowBox[{"16", " ", "S"}]}], ")"}]}], "+", 
       RowBox[{"4", " ", 
        SuperscriptBox["b", "8"], " ", 
        SuperscriptBox["c", "8"], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"219", " ", 
           SuperscriptBox["c", "2"]}], "+", 
          RowBox[{"353", " ", "S"}]}], ")"}]}], "+", 
       RowBox[{"8", " ", 
        SuperscriptBox["b", "14"], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"5", " ", 
           SuperscriptBox["c", "4"]}], "+", 
          RowBox[{"4", " ", 
           SuperscriptBox["c", "2"], " ", "S"}]}], ")"}]}], "+", 
       RowBox[{"4", " ", 
        SuperscriptBox["b", "12"], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"131", " ", 
           SuperscriptBox["c", "6"]}], "-", 
          RowBox[{"96", " ", 
           SuperscriptBox["c", "4"], " ", "S"}]}], ")"}]}], "+", 
       RowBox[{
        SuperscriptBox["b", "10"], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           RowBox[{"-", "1378"}], " ", 
           SuperscriptBox["c", "8"]}], "+", 
          RowBox[{"272", " ", 
           SuperscriptBox["c", "6"], " ", "S"}]}], ")"}]}], "+", 
       RowBox[{
        SuperscriptBox["b", "4"], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           RowBox[{"-", "1308"}], " ", 
           SuperscriptBox["c", "14"]}], "+", 
          RowBox[{"896", " ", 
           SuperscriptBox["c", "12"], " ", "S"}]}], ")"}]}]}], ")"}]}]}], ",", 
   RowBox[{"2", " ", 
    SuperscriptBox["b", "2"], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       RowBox[{"-", "9"}], " ", 
       SuperscriptBox["a", "16"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"5", " ", 
          SuperscriptBox["b", "2"]}], "-", 
         RowBox[{"2", " ", "S"}]}], ")"}]}], "+", 
      RowBox[{"2", " ", 
       SuperscriptBox["a", "14"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"103", " ", 
          SuperscriptBox["b", "4"]}], "+", 
         RowBox[{"36", " ", 
          SuperscriptBox["b", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"5", " ", 
             SuperscriptBox["c", "2"]}], "-", "S"}], ")"}]}], "-", 
         RowBox[{"72", " ", 
          SuperscriptBox["c", "2"], " ", "S"}]}], ")"}]}], "-", 
      RowBox[{"2", " ", 
       SuperscriptBox["a", "12"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"144", " ", 
          SuperscriptBox["b", "6"]}], "-", 
         RowBox[{"252", " ", 
          SuperscriptBox["c", "4"], " ", "S"}], "+", 
         RowBox[{
          SuperscriptBox["b", "4"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"515", " ", 
             SuperscriptBox["c", "2"]}], "+", 
            RowBox[{"36", " ", "S"}]}], ")"}]}], "+", 
         RowBox[{"90", " ", 
          SuperscriptBox["b", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"7", " ", 
             SuperscriptBox["c", "4"]}], "-", 
            RowBox[{"2", " ", 
             SuperscriptBox["c", "2"], " ", "S"}]}], ")"}]}]}], ")"}]}], "+", 
      RowBox[{"2", " ", 
       SuperscriptBox["a", "10"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"14", " ", 
          SuperscriptBox["b", "8"]}], "-", 
         RowBox[{"504", " ", 
          SuperscriptBox["c", "6"], " ", "S"}], "+", 
         RowBox[{
          SuperscriptBox["b", "6"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"218", " ", 
             SuperscriptBox["c", "2"]}], "+", 
            RowBox[{"244", " ", "S"}]}], ")"}]}], "+", 
         RowBox[{"103", " ", 
          SuperscriptBox["b", "4"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"9", " ", 
             SuperscriptBox["c", "4"]}], "+", 
            RowBox[{"4", " ", 
             SuperscriptBox["c", "2"], " ", "S"}]}], ")"}]}], "+", 
         RowBox[{"36", " ", 
          SuperscriptBox["b", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"35", " ", 
             SuperscriptBox["c", "6"]}], "-", 
            RowBox[{"9", " ", 
             SuperscriptBox["c", "4"], " ", "S"}]}], ")"}]}]}], ")"}]}], "-", 
      RowBox[{"2", " ", 
       SuperscriptBox["a", "6"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"143", " ", 
          SuperscriptBox["b", "12"]}], "+", 
         RowBox[{"12", " ", 
          SuperscriptBox["b", "10"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"23", " ", 
             SuperscriptBox["c", "2"]}], "-", 
            RowBox[{"8", " ", "S"}]}], ")"}]}], "+", 
         RowBox[{"504", " ", 
          SuperscriptBox["c", "10"], " ", "S"}], "-", 
         RowBox[{"180", " ", 
          SuperscriptBox["b", "2"], " ", 
          SuperscriptBox["c", "8"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"7", " ", 
             SuperscriptBox["c", "2"]}], "+", "S"}], ")"}]}], "+", 
         RowBox[{"8", " ", 
          SuperscriptBox["b", "8"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"46", " ", 
             SuperscriptBox["c", "4"]}], "-", 
            RowBox[{"17", " ", 
             SuperscriptBox["c", "2"], " ", "S"}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["b", "6"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"996", " ", 
             SuperscriptBox["c", "6"]}], "-", 
            RowBox[{"592", " ", 
             SuperscriptBox["c", "4"], " ", "S"}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["b", "4"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"515", " ", 
             SuperscriptBox["c", "8"]}], "-", 
            RowBox[{"1896", " ", 
             SuperscriptBox["c", "6"], " ", "S"}]}], ")"}]}]}], ")"}]}], "+", 
      RowBox[{"2", " ", 
       SuperscriptBox["a", "8"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"142", " ", 
          SuperscriptBox["b", "10"]}], "+", 
         RowBox[{"6", " ", 
          SuperscriptBox["b", "8"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"59", " ", 
             SuperscriptBox["c", "2"]}], "-", 
            RowBox[{"46", " ", "S"}]}], ")"}]}], "+", 
         RowBox[{"630", " ", 
          SuperscriptBox["c", "8"], " ", "S"}], "+", 
         RowBox[{
          SuperscriptBox["b", "6"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"424", " ", 
             SuperscriptBox["c", "4"]}], "-", 
            RowBox[{"836", " ", 
             SuperscriptBox["c", "2"], " ", "S"}]}], ")"}]}], "-", 
         RowBox[{
          SuperscriptBox["b", "4"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"515", " ", 
             SuperscriptBox["c", "6"]}], "+", 
            RowBox[{"1324", " ", 
             SuperscriptBox["c", "4"], " ", "S"}]}], ")"}]}], "-", 
         RowBox[{"45", " ", 
          SuperscriptBox["b", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"35", " ", 
             SuperscriptBox["c", "8"]}], "-", 
            RowBox[{"4", " ", 
             SuperscriptBox["c", "6"], " ", "S"}]}], ")"}]}]}], ")"}]}], "+", 
      RowBox[{"2", " ", 
       SuperscriptBox["a", "4"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"64", " ", 
          SuperscriptBox["b", "14"]}], "+", 
         RowBox[{
          SuperscriptBox["b", "4"], " ", 
          SuperscriptBox["c", "8"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"927", " ", 
             SuperscriptBox["c", "2"]}], "-", 
            RowBox[{"1324", " ", "S"}]}], ")"}]}], "+", 
         RowBox[{"252", " ", 
          SuperscriptBox["c", "12"], " ", "S"}], "+", 
         RowBox[{
          SuperscriptBox["b", "12"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"7", " ", 
             SuperscriptBox["c", "2"]}], "+", 
            RowBox[{"16", " ", "S"}]}], ")"}]}], "-", 
         RowBox[{"18", " ", 
          SuperscriptBox["b", "2"], " ", 
          SuperscriptBox["c", "10"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"35", " ", 
             SuperscriptBox["c", "2"]}], "+", 
            RowBox[{"18", " ", "S"}]}], ")"}]}], "-", 
         RowBox[{"4", " ", 
          SuperscriptBox["b", "10"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"5", " ", 
             SuperscriptBox["c", "4"]}], "-", 
            RowBox[{"36", " ", 
             SuperscriptBox["c", "2"], " ", "S"}]}], ")"}]}], "-", 
         RowBox[{"8", " ", 
          SuperscriptBox["b", "8"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"46", " ", 
             SuperscriptBox["c", "6"]}], "-", 
            RowBox[{"43", " ", 
             SuperscriptBox["c", "4"], " ", "S"}]}], ")"}]}], "+", 
         RowBox[{"8", " ", 
          SuperscriptBox["b", "6"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"53", " ", 
             SuperscriptBox["c", "8"]}], "+", 
            RowBox[{"74", " ", 
             SuperscriptBox["c", "6"], " ", "S"}]}], ")"}]}]}], ")"}]}], "+", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["b", "2"], "-", 
         SuperscriptBox["c", "2"]}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["b", "16"], "+", 
         RowBox[{
          SuperscriptBox["b", "6"], " ", 
          SuperscriptBox["c", "8"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"127", " ", 
             SuperscriptBox["c", "2"]}], "-", 
            RowBox[{"362", " ", "S"}]}], ")"}]}], "-", 
         RowBox[{"7", " ", 
          SuperscriptBox["b", "4"], " ", 
          SuperscriptBox["c", "10"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"23", " ", 
             SuperscriptBox["c", "2"]}], "-", 
            RowBox[{"18", " ", "S"}]}], ")"}]}], "-", 
         RowBox[{"18", " ", 
          SuperscriptBox["c", "14"], " ", "S"}], "+", 
         RowBox[{"9", " ", 
          SuperscriptBox["b", "2"], " ", 
          SuperscriptBox["c", "12"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"5", " ", 
             SuperscriptBox["c", "2"]}], "+", 
            RowBox[{"6", " ", "S"}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["b", "14"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"-", "27"}], " ", 
             SuperscriptBox["c", "2"]}], "+", 
            RowBox[{"14", " ", "S"}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["b", "12"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"101", " ", 
             SuperscriptBox["c", "4"]}], "-", 
            RowBox[{"34", " ", 
             SuperscriptBox["c", "2"], " ", "S"}]}], ")"}]}], "-", 
         RowBox[{
          SuperscriptBox["b", "10"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"185", " ", 
             SuperscriptBox["c", "6"]}], "+", 
            RowBox[{"2", " ", 
             SuperscriptBox["c", "4"], " ", "S"}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["b", "8"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"99", " ", 
             SuperscriptBox["c", "8"]}], "+", 
            RowBox[{"190", " ", 
             SuperscriptBox["c", "6"], " ", "S"}]}], ")"}]}]}], ")"}]}], "-", 
      RowBox[{"2", " ", 
       SuperscriptBox["a", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"14", " ", 
          SuperscriptBox["b", "16"]}], "+", 
         RowBox[{"103", " ", 
          SuperscriptBox["b", "4"], " ", 
          SuperscriptBox["c", "10"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"5", " ", 
             SuperscriptBox["c", "2"]}], "-", 
            RowBox[{"4", " ", "S"}]}], ")"}]}], "+", 
         RowBox[{"72", " ", 
          SuperscriptBox["c", "14"], " ", "S"}], "-", 
         RowBox[{"180", " ", 
          SuperscriptBox["b", "2"], " ", 
          SuperscriptBox["c", "12"], " ", 
          RowBox[{"(", 
           RowBox[{
            SuperscriptBox["c", "2"], "+", "S"}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["b", "14"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"-", "62"}], " ", 
             SuperscriptBox["c", "2"]}], "+", 
            RowBox[{"24", " ", "S"}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["b", "12"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"-", "7"}], " ", 
             SuperscriptBox["c", "4"]}], "+", 
            RowBox[{"76", " ", 
             SuperscriptBox["c", "2"], " ", "S"}]}], ")"}]}], "+", 
         RowBox[{"12", " ", 
          SuperscriptBox["b", "10"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"23", " ", 
             SuperscriptBox["c", "6"]}], "-", 
            RowBox[{"12", " ", 
             SuperscriptBox["c", "4"], " ", "S"}]}], ")"}]}], "-", 
         RowBox[{"2", " ", 
          SuperscriptBox["b", "8"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"177", " ", 
             SuperscriptBox["c", "8"]}], "+", 
            RowBox[{"68", " ", 
             SuperscriptBox["c", "6"], " ", "S"}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["b", "6"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"-", "218"}], " ", 
             SuperscriptBox["c", "10"]}], "+", 
            RowBox[{"836", " ", 
             SuperscriptBox["c", "8"], " ", "S"}]}], ")"}]}]}], ")"}]}]}], 
     ")"}]}], ",", 
   RowBox[{
    RowBox[{
     RowBox[{"-", "9"}], " ", 
     SuperscriptBox["a", "18"], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"5", " ", 
        SuperscriptBox["b", "2"]}], "-", 
       RowBox[{"2", " ", "S"}]}], ")"}]}], "+", 
    RowBox[{
     SuperscriptBox["a", "16"], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"215", " ", 
        SuperscriptBox["b", "4"]}], "+", 
       RowBox[{"9", " ", 
        SuperscriptBox["b", "2"], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"45", " ", 
           SuperscriptBox["c", "2"]}], "-", 
          RowBox[{"8", " ", "S"}]}], ")"}]}], "-", 
       RowBox[{"162", " ", 
        SuperscriptBox["c", "2"], " ", "S"}]}], ")"}]}], "-", 
    RowBox[{"12", " ", 
     SuperscriptBox["a", "14"], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"27", " ", 
        SuperscriptBox["b", "6"]}], "-", 
       RowBox[{"54", " ", 
        SuperscriptBox["c", "4"], " ", "S"}], "+", 
       RowBox[{
        SuperscriptBox["b", "4"], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"109", " ", 
           SuperscriptBox["c", "2"]}], "+", 
          RowBox[{"6", " ", "S"}]}], ")"}]}], "+", 
       RowBox[{"9", " ", 
        SuperscriptBox["b", "2"], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"15", " ", 
           SuperscriptBox["c", "4"]}], "-", 
          RowBox[{"4", " ", 
           SuperscriptBox["c", "2"], " ", "S"}]}], ")"}]}]}], ")"}]}], "+", 
    RowBox[{"4", " ", 
     SuperscriptBox["a", "12"], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"7", " ", 
        SuperscriptBox["b", "8"]}], "-", 
       RowBox[{"378", " ", 
        SuperscriptBox["c", "6"], " ", "S"}], "+", 
       RowBox[{"2", " ", 
        SuperscriptBox["b", "6"], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"113", " ", 
           SuperscriptBox["c", "2"]}], "+", 
          RowBox[{"70", " ", "S"}]}], ")"}]}], "+", 
       RowBox[{"112", " ", 
        SuperscriptBox["b", "4"], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"7", " ", 
           SuperscriptBox["c", "4"]}], "+", 
          RowBox[{"2", " ", 
           SuperscriptBox["c", "2"], " ", "S"}]}], ")"}]}], "+", 
       RowBox[{"63", " ", 
        SuperscriptBox["b", "2"], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"15", " ", 
           SuperscriptBox["c", "6"]}], "-", 
          RowBox[{"4", " ", 
           SuperscriptBox["c", "4"], " ", "S"}]}], ")"}]}]}], ")"}]}], "+", 
    RowBox[{"4", " ", 
     SuperscriptBox["a", "6"], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"65", " ", 
        SuperscriptBox["b", "14"]}], "+", 
       RowBox[{"35", " ", 
        SuperscriptBox["b", "4"], " ", 
        SuperscriptBox["c", "8"], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"17", " ", 
           SuperscriptBox["c", "2"]}], "-", 
          RowBox[{"46", " ", "S"}]}], ")"}]}], "+", 
       RowBox[{"378", " ", 
        SuperscriptBox["c", "12"], " ", "S"}], "+", 
       RowBox[{"6", " ", 
        SuperscriptBox["b", "8"], " ", 
        SuperscriptBox["c", "4"], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"49", " ", 
           SuperscriptBox["c", "2"]}], "+", "S"}], ")"}]}], "-", 
       RowBox[{"63", " ", 
        SuperscriptBox["b", "2"], " ", 
        SuperscriptBox["c", "10"], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"15", " ", 
           SuperscriptBox["c", "2"]}], "+", 
          RowBox[{"4", " ", "S"}]}], ")"}]}], "+", 
       RowBox[{
        SuperscriptBox["b", "12"], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"131", " ", 
           SuperscriptBox["c", "2"]}], "+", 
          RowBox[{"26", " ", "S"}]}], ")"}]}], "+", 
       RowBox[{
        SuperscriptBox["b", "10"], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"227", " ", 
           SuperscriptBox["c", "4"]}], "+", 
          RowBox[{"68", " ", 
           SuperscriptBox["c", "2"], " ", "S"}]}], ")"}]}], "+", 
       RowBox[{"5", " ", 
        SuperscriptBox["b", "6"], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"151", " ", 
           SuperscriptBox["c", "8"]}], "-", 
          RowBox[{"72", " ", 
           SuperscriptBox["c", "6"], " ", "S"}]}], ")"}]}]}], ")"}]}], "+", 
    RowBox[{"2", " ", 
     SuperscriptBox["a", "10"], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"215", " ", 
        SuperscriptBox["b", "10"]}], "+", 
       RowBox[{
        SuperscriptBox["b", "8"], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"438", " ", 
           SuperscriptBox["c", "2"]}], "-", 
          RowBox[{"374", " ", "S"}]}], ")"}]}], "+", 
       RowBox[{"1134", " ", 
        SuperscriptBox["c", "8"], " ", "S"}], "+", 
       RowBox[{"4", " ", 
        SuperscriptBox["b", "6"], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"11", " ", 
           SuperscriptBox["c", "4"]}], "-", 
          RowBox[{"324", " ", 
           SuperscriptBox["c", "2"], " ", "S"}]}], ")"}]}], "-", 
       RowBox[{"14", " ", 
        SuperscriptBox["b", "4"], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"121", " ", 
           SuperscriptBox["c", "6"]}], "+", 
          RowBox[{"124", " ", 
           SuperscriptBox["c", "4"], " ", "S"}]}], ")"}]}], "-", 
       RowBox[{"63", " ", 
        SuperscriptBox["b", "2"], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"45", " ", 
           SuperscriptBox["c", "8"]}], "-", 
          RowBox[{"8", " ", 
           SuperscriptBox["c", "6"], " ", "S"}]}], ")"}]}]}], ")"}]}], "+", 
    RowBox[{
     SuperscriptBox["a", "8"], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        RowBox[{"-", "506"}], " ", 
        SuperscriptBox["b", "12"]}], "+", 
       RowBox[{"5670", " ", 
        SuperscriptBox["b", "2"], " ", 
        SuperscriptBox["c", "10"]}], "-", 
       RowBox[{"2268", " ", 
        SuperscriptBox["c", "10"], " ", "S"}], "+", 
       RowBox[{
        SuperscriptBox["b", "10"], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           RowBox[{"-", "1378"}], " ", 
           SuperscriptBox["c", "2"]}], "+", 
          RowBox[{"304", " ", "S"}]}], ")"}]}], "-", 
       RowBox[{"4", " ", 
        SuperscriptBox["b", "8"], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"557", " ", 
           SuperscriptBox["c", "4"]}], "-", 
          RowBox[{"353", " ", 
           SuperscriptBox["c", "2"], " ", "S"}]}], ")"}]}], "-", 
       RowBox[{"4", " ", 
        SuperscriptBox["b", "6"], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"665", " ", 
           SuperscriptBox["c", "6"]}], "-", 
          RowBox[{"984", " ", 
           SuperscriptBox["c", "4"], " ", "S"}]}], ")"}]}], "+", 
       RowBox[{"70", " ", 
        SuperscriptBox["b", "4"], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"9", " ", 
           SuperscriptBox["c", "8"]}], "+", 
          RowBox[{"92", " ", 
           SuperscriptBox["c", "6"], " ", "S"}]}], ")"}]}]}], ")"}]}], "-", 
    RowBox[{"4", " ", 
     SuperscriptBox["a", "4"], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"15", " ", 
        SuperscriptBox["b", "16"]}], "+", 
       RowBox[{"14", " ", 
        SuperscriptBox["b", "4"], " ", 
        SuperscriptBox["c", "10"], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"47", " ", 
           SuperscriptBox["c", "2"]}], "-", 
          RowBox[{"62", " ", "S"}]}], ")"}]}], "+", 
       RowBox[{"162", " ", 
        SuperscriptBox["c", "14"], " ", "S"}], "-", 
       RowBox[{"9", " ", 
        SuperscriptBox["b", "2"], " ", 
        SuperscriptBox["c", "12"], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"45", " ", 
           SuperscriptBox["c", "2"]}], "+", 
          RowBox[{"28", " ", "S"}]}], ")"}]}], "+", 
       RowBox[{
        SuperscriptBox["b", "14"], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           RowBox[{"-", "10"}], " ", 
           SuperscriptBox["c", "2"]}], "+", 
          RowBox[{"36", " ", "S"}]}], ")"}]}], "+", 
       RowBox[{"4", " ", 
        SuperscriptBox["b", "6"], " ", 
        SuperscriptBox["c", "8"], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"46", " ", 
           SuperscriptBox["c", "2"]}], "+", 
          RowBox[{"111", " ", "S"}]}], ")"}]}], "+", 
       RowBox[{
        SuperscriptBox["b", "12"], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           RowBox[{"-", "14"}], " ", 
           SuperscriptBox["c", "4"]}], "+", 
          RowBox[{"96", " ", 
           SuperscriptBox["c", "2"], " ", "S"}]}], ")"}]}], "+", 
       RowBox[{
        SuperscriptBox["b", "10"], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"29", " ", 
           SuperscriptBox["c", "6"]}], "+", 
          RowBox[{"144", " ", 
           SuperscriptBox["c", "4"], " ", "S"}]}], ")"}]}], "+", 
       RowBox[{
        SuperscriptBox["b", "8"], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           RowBox[{"-", "165"}], " ", 
           SuperscriptBox["c", "8"]}], "+", 
          RowBox[{"202", " ", 
           SuperscriptBox["c", "6"], " ", "S"}]}], ")"}]}]}], ")"}]}], "+", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       SuperscriptBox["b", "2"], "-", 
       SuperscriptBox["c", "2"]}], ")"}], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"3", " ", 
        SuperscriptBox["b", "18"]}], "+", 
       RowBox[{"2", " ", 
        SuperscriptBox["b", "4"], " ", 
        SuperscriptBox["c", "12"], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"76", " ", 
           SuperscriptBox["c", "2"]}], "-", 
          RowBox[{"63", " ", "S"}]}], ")"}]}], "-", 
       RowBox[{"8", " ", 
        SuperscriptBox["b", "16"], " ", "S"}], "-", 
       RowBox[{"26", " ", 
        SuperscriptBox["b", "12"], " ", 
        SuperscriptBox["c", "4"], " ", "S"}], "+", 
       RowBox[{"18", " ", 
        SuperscriptBox["c", "16"], " ", "S"}], "-", 
       RowBox[{"9", " ", 
        SuperscriptBox["b", "2"], " ", 
        SuperscriptBox["c", "14"], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"5", " ", 
           SuperscriptBox["c", "2"]}], "+", 
          RowBox[{"6", " ", "S"}]}], ")"}]}], "-", 
       RowBox[{"6", " ", 
        SuperscriptBox["b", "8"], " ", 
        SuperscriptBox["c", "8"], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"12", " ", 
           SuperscriptBox["c", "2"]}], "+", 
          RowBox[{"11", " ", "S"}]}], ")"}]}], "+", 
       RowBox[{
        SuperscriptBox["b", "14"], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           RowBox[{"-", "4"}], " ", 
           SuperscriptBox["c", "4"]}], "+", 
          RowBox[{"22", " ", 
           SuperscriptBox["c", "2"], " ", "S"}]}], ")"}]}], "+", 
       RowBox[{"2", " ", 
        SuperscriptBox["b", "10"], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"33", " ", 
           SuperscriptBox["c", "8"]}], "+", 
          RowBox[{"7", " ", 
           SuperscriptBox["c", "6"], " ", "S"}]}], ")"}]}], "+", 
       RowBox[{
        SuperscriptBox["b", "6"], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           RowBox[{"-", "100"}], " ", 
           SuperscriptBox["c", "12"]}], "+", 
          RowBox[{"290", " ", 
           SuperscriptBox["c", "10"], " ", "S"}]}], ")"}]}]}], ")"}]}], "-", 
    RowBox[{
     SuperscriptBox["a", "2"], " ", 
     RowBox[{"(", 
      RowBox[{
       SuperscriptBox["b", "18"], "+", 
       RowBox[{
        SuperscriptBox["b", "16"], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"60", " ", 
           SuperscriptBox["c", "2"]}], "-", 
          RowBox[{"58", " ", "S"}]}], ")"}]}], "+", 
       RowBox[{"32", " ", 
        SuperscriptBox["b", "6"], " ", 
        SuperscriptBox["c", "10"], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"17", " ", 
           SuperscriptBox["c", "2"]}], "-", 
          RowBox[{"54", " ", "S"}]}], ")"}]}], "-", 
       RowBox[{"162", " ", 
        SuperscriptBox["c", "16"], " ", "S"}], "+", 
       RowBox[{"27", " ", 
        SuperscriptBox["b", "2"], " ", 
        SuperscriptBox["c", "14"], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"15", " ", 
           SuperscriptBox["c", "2"]}], "+", 
          RowBox[{"16", " ", "S"}]}], ")"}]}], "+", 
       RowBox[{"4", " ", 
        SuperscriptBox["b", "8"], " ", 
        SuperscriptBox["c", "8"], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"121", " ", 
           SuperscriptBox["c", "2"]}], "+", 
          RowBox[{"59", " ", "S"}]}], ")"}]}], "-", 
       RowBox[{"16", " ", 
        SuperscriptBox["b", "14"], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"3", " ", 
           SuperscriptBox["c", "4"]}], "+", 
          RowBox[{"2", " ", 
           SuperscriptBox["c", "2"], " ", "S"}]}], ")"}]}], "+", 
       RowBox[{"4", " ", 
        SuperscriptBox["b", "12"], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"19", " ", 
           SuperscriptBox["c", "6"]}], "+", 
          RowBox[{"4", " ", 
           SuperscriptBox["c", "4"], " ", "S"}]}], ")"}]}], "-", 
       RowBox[{"2", " ", 
        SuperscriptBox["b", "10"], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"147", " ", 
           SuperscriptBox["c", "8"]}], "+", 
          RowBox[{"40", " ", 
           SuperscriptBox["c", "6"], " ", "S"}]}], ")"}]}], "+", 
       RowBox[{
        SuperscriptBox["b", "4"], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           RowBox[{"-", "1164"}], " ", 
           SuperscriptBox["c", "14"]}], "+", 
          RowBox[{"896", " ", 
           SuperscriptBox["c", "12"], " ", "S"}]}], ")"}]}]}], ")"}]}]}]}], 
  "}"}]], "Output",
 CellChangeTimes->{3.9555303131049366`*^9, 3.955530352158743*^9, 
  3.955530503225046*^9, 3.9611230742701035`*^9, 3.9614129618547497`*^9},
 CellLabel->
  "Out[287]=",ExpressionUUID->"635425f6-6caf-4c23-855c-c98b908936d7"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"Simplify", "[", 
    RowBox[{
     RowBox[{"Cross", "[", 
      RowBox[{"ptQ", ",", "ptE"}], "]"}], ",", 
     RowBox[{"ortho", "&&", "equi"}]}], "]"}], "/.", "sustS"}], "//", 
  "Factor"}]], "Input",
 CellChangeTimes->{{3.9555303665747395`*^9, 3.9555304292773304`*^9}},
 CellLabel->
  "In[288]:=",ExpressionUUID->"35a92d1f-c427-9e4d-8430-9c5cb57fd82d"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0", ",", "0", ",", "0"}], "}"}]], "Output",
 CellChangeTimes->{{3.955530398289353*^9, 3.955530430068479*^9}, {
   3.955530487964885*^9, 3.955530506319191*^9}, 3.961123078642618*^9, 
   3.961412962366026*^9},
 CellLabel->
  "Out[288]=",ExpressionUUID->"c4b235fa-26af-48b8-bf9c-4f66beb9ba0b"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["X (487)", "Subsection",
 CellChangeTimes->{{3.9547318899015656`*^9, 3.954731893974074*^9}, {
   3.95473265785647*^9, 3.954732659663503*^9}, {3.954732890679308*^9, 
   3.954732891487614*^9}, 3.954733054504549*^9, 3.954734909088499*^9, {
   3.9547456826790233`*^9, 3.954745683267832*^9}, {3.954746186388487*^9, 
   3.9547461864024734`*^9}, {3.9547472494340367`*^9, 
   3.9547472496864853`*^9}, {3.9547584031954937`*^9, 
   3.9547584032740726`*^9}},ExpressionUUID->"edfd1f34-ecd8-8141-abb0-\
b280d44e94ec"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"X487", "=", 
  RowBox[{"Simplificar", "[", 
   RowBox[{
    RowBox[{"Expand", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"ETC", "[", 
        RowBox[{"[", 
         RowBox[{"487", ",", "2"}], "]"}], "]"}], "/.", "sustS"}], "/.", 
      "sustC"}], "]"}], "/.", "sustS"}], "]"}]}]], "Input",
 CellChangeTimes->{{3.954747610010666*^9, 3.954747684007263*^9}, {
  3.954758407141165*^9, 3.954758407198597*^9}, {3.961123109854456*^9, 
  3.9611231123025684`*^9}},
 CellLabel->
  "In[289]:=",ExpressionUUID->"f7fe21ca-a76c-b048-b53f-646da5a416f4"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"-", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "2"], "-", 
        SuperscriptBox["b", "2"], "-", 
        SuperscriptBox["c", "2"]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "4"], "+", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "2"], "-", 
           SuperscriptBox["c", "2"]}], ")"}], "2"], "-", 
        RowBox[{"2", " ", 
         SuperscriptBox["a", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "2"], "+", 
           SuperscriptBox["c", "2"], "-", 
           RowBox[{"2", " ", "S"}]}], ")"}]}]}], ")"}]}], ")"}]}], ",", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      SuperscriptBox["a", "2"], "-", 
      SuperscriptBox["b", "2"], "+", 
      SuperscriptBox["c", "2"]}], ")"}], " ", 
    RowBox[{"(", 
     RowBox[{
      SuperscriptBox["a", "4"], "+", 
      SuperscriptBox["b", "4"], "+", 
      SuperscriptBox["c", "4"], "-", 
      RowBox[{"2", " ", 
       SuperscriptBox["a", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["b", "2"], "+", 
         SuperscriptBox["c", "2"]}], ")"}]}], "-", 
      RowBox[{"2", " ", 
       SuperscriptBox["b", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["c", "2"], "-", 
         RowBox[{"2", " ", "S"}]}], ")"}]}]}], ")"}]}], ",", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      SuperscriptBox["a", "2"], "+", 
      SuperscriptBox["b", "2"], "-", 
      SuperscriptBox["c", "2"]}], ")"}], " ", 
    RowBox[{"(", 
     RowBox[{
      SuperscriptBox["a", "4"], "+", 
      SuperscriptBox["b", "4"], "-", 
      RowBox[{"2", " ", 
       SuperscriptBox["b", "2"], " ", 
       SuperscriptBox["c", "2"]}], "+", 
      SuperscriptBox["c", "4"], "-", 
      RowBox[{"2", " ", 
       SuperscriptBox["a", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["b", "2"], "+", 
         SuperscriptBox["c", "2"]}], ")"}]}], "+", 
      RowBox[{"4", " ", 
       SuperscriptBox["c", "2"], " ", "S"}]}], ")"}]}]}], "}"}]], "Output",
 CellChangeTimes->{
  3.954747619393961*^9, {3.9547476554628716`*^9, 3.9547476846845*^9}, 
   3.9547583570794487`*^9, 3.9547584082339993`*^9, 3.9611231142275333`*^9, 
   3.9614129624147577`*^9},
 CellLabel->
  "Out[289]=",ExpressionUUID->"0d1b379b-3645-415a-a525-c878c7b73546"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"{", 
    RowBox[{"ptF", ",", "ptG", ",", "ptH", ",", "ptI"}], "}"}], "=", 
   RowBox[{"Simplificar", "/@", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       RowBox[{"centralQuadrilateral", "[", 
        RowBox[{"X487", ",", "ptE"}], "]"}], "/.", "sustS"}], "/.", "sustC"}],
      ")"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"{", 
   RowBox[{"ptF", ",", "ptG", ",", "ptH", ",", "ptI"}], "}"}], "=", 
  RowBox[{
   RowBox[{
    RowBox[{"Simplificar", "[", 
     RowBox[{
      RowBox[{"Expand", "[", "#", "]"}], "/.", "sustS"}], "]"}], "&"}], "/@", 
   RowBox[{"{", 
    RowBox[{"ptF", ",", "ptG", ",", "ptH", ",", "ptI"}], "}"}]}]}]}], "Input",
 CellChangeTimes->{{3.954734614817431*^9, 3.954734615601975*^9}, 
   3.954745698225521*^9, {3.954746220639621*^9, 3.954746220703642*^9}, {
   3.954747257081831*^9, 3.954747257656212*^9}, {3.9547476915928345`*^9, 
   3.954747692511669*^9}, {3.954758099553793*^9, 3.954758117861986*^9}, {
   3.9611231190473213`*^9, 3.961123121247467*^9}},
 CellLabel->
  "In[290]:=",ExpressionUUID->"f25eccec-9cbe-eb47-b2cb-969a73dc08df"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", 
       SuperscriptBox["a", "6"]}], "+", 
      RowBox[{
       SuperscriptBox["a", "4"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"-", "3"}], " ", 
          SuperscriptBox["b", "2"]}], "+", 
         RowBox[{"3", " ", 
          SuperscriptBox["c", "2"]}], "+", 
         RowBox[{"6", " ", "S"}]}], ")"}]}], "-", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["b", "2"], "-", 
         SuperscriptBox["c", "2"]}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["b", "4"], "+", 
         SuperscriptBox["c", "4"], "+", 
         RowBox[{"6", " ", 
          SuperscriptBox["c", "2"], " ", "S"}], "-", 
         RowBox[{"2", " ", 
          SuperscriptBox["b", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            SuperscriptBox["c", "2"], "+", "S"}], ")"}]}]}], ")"}]}], "+", 
      RowBox[{
       SuperscriptBox["a", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["b", "4"], "+", 
         RowBox[{"6", " ", 
          SuperscriptBox["b", "2"], " ", 
          SuperscriptBox["c", "2"]}], "-", 
         RowBox[{"3", " ", 
          RowBox[{"(", 
           RowBox[{
            SuperscriptBox["c", "4"], "+", 
            RowBox[{"4", " ", 
             SuperscriptBox["c", "2"], " ", "S"}]}], ")"}]}]}], ")"}]}]}], ",", 
     RowBox[{
      RowBox[{"-", "2"}], " ", 
      RowBox[{"(", 
       RowBox[{"a", "-", "c"}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{"a", "+", "c"}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "4"], "+", 
        SuperscriptBox["c", "4"], "-", 
        RowBox[{
         SuperscriptBox["b", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["c", "2"], "-", 
           RowBox[{"4", " ", "S"}]}], ")"}]}], "-", 
        RowBox[{"2", " ", 
         SuperscriptBox["c", "2"], " ", "S"}], "+", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"-", "3"}], " ", 
            SuperscriptBox["b", "2"]}], "-", 
           RowBox[{"2", " ", 
            SuperscriptBox["c", "2"]}], "+", 
           RowBox[{"2", " ", "S"}]}], ")"}]}]}], ")"}]}], ",", 
     RowBox[{
      RowBox[{"-", 
       SuperscriptBox["a", "6"]}], "-", 
      SuperscriptBox["b", "6"], "+", 
      SuperscriptBox["c", "6"], "+", 
      RowBox[{
       SuperscriptBox["a", "4"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"3", " ", 
          SuperscriptBox["b", "2"]}], "+", 
         RowBox[{"3", " ", 
          SuperscriptBox["c", "2"]}], "-", 
         RowBox[{"2", " ", "S"}]}], ")"}]}], "-", 
      RowBox[{"2", " ", 
       SuperscriptBox["c", "4"], " ", "S"}], "+", 
      RowBox[{
       SuperscriptBox["b", "4"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"5", " ", 
          SuperscriptBox["c", "2"]}], "+", 
         RowBox[{"2", " ", "S"}]}], ")"}]}], "-", 
      RowBox[{
       SuperscriptBox["a", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["b", "4"], "+", 
         RowBox[{"3", " ", 
          SuperscriptBox["c", "4"]}], "-", 
         RowBox[{"2", " ", 
          SuperscriptBox["b", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            SuperscriptBox["c", "2"], "-", 
            RowBox[{"2", " ", "S"}]}], ")"}]}], "-", 
         RowBox[{"4", " ", 
          SuperscriptBox["c", "2"], " ", "S"}]}], ")"}]}], "-", 
      RowBox[{
       SuperscriptBox["b", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"5", " ", 
          SuperscriptBox["c", "4"]}], "+", 
         RowBox[{"4", " ", 
          SuperscriptBox["c", "2"], " ", "S"}]}], ")"}]}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      SuperscriptBox["a", "6"], "-", 
      SuperscriptBox["b", "6"], "-", 
      RowBox[{
       SuperscriptBox["b", "4"], " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["c", "2"], "-", 
         RowBox[{"2", " ", "S"}]}], ")"}]}], "-", 
      RowBox[{
       SuperscriptBox["c", "4"], " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["c", "2"], "+", 
         RowBox[{"2", " ", "S"}]}], ")"}]}], "-", 
      RowBox[{
       SuperscriptBox["a", "4"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"5", " ", 
          SuperscriptBox["b", "2"]}], "+", 
         RowBox[{"3", " ", 
          SuperscriptBox["c", "2"]}], "+", 
         RowBox[{"2", " ", "S"}]}], ")"}]}], "+", 
      RowBox[{
       SuperscriptBox["b", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"3", " ", 
          SuperscriptBox["c", "4"]}], "-", 
         RowBox[{"4", " ", 
          SuperscriptBox["c", "2"], " ", "S"}]}], ")"}]}], "+", 
      RowBox[{
       SuperscriptBox["a", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"5", " ", 
          SuperscriptBox["b", "4"]}], "+", 
         RowBox[{"3", " ", 
          SuperscriptBox["c", "4"]}], "+", 
         RowBox[{"2", " ", 
          SuperscriptBox["b", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            SuperscriptBox["c", "2"], "-", 
            RowBox[{"2", " ", "S"}]}], ")"}]}], "+", 
         RowBox[{"4", " ", 
          SuperscriptBox["c", "2"], " ", "S"}]}], ")"}]}]}], ",", 
     RowBox[{"2", " ", 
      RowBox[{"(", 
       RowBox[{"a", "-", "c"}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{"a", "+", "c"}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "4"], "+", 
        SuperscriptBox["c", "4"], "+", 
        RowBox[{"2", " ", 
         SuperscriptBox["c", "2"], " ", "S"}], "+", 
        RowBox[{
         SuperscriptBox["b", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"-", "3"}], " ", 
            SuperscriptBox["c", "2"]}], "+", 
           RowBox[{"4", " ", "S"}]}], ")"}]}], "-", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "2"], "+", 
           RowBox[{"2", " ", 
            RowBox[{"(", 
             RowBox[{
              SuperscriptBox["c", "2"], "+", "S"}], ")"}]}]}], ")"}]}]}], 
       ")"}]}], ",", 
     RowBox[{
      SuperscriptBox["a", "6"], "-", 
      SuperscriptBox["b", "6"], "-", 
      RowBox[{"3", " ", 
       SuperscriptBox["b", "2"], " ", 
       SuperscriptBox["c", "4"]}], "-", 
      SuperscriptBox["c", "6"], "-", 
      RowBox[{"3", " ", 
       SuperscriptBox["a", "4"], " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["b", "2"], "+", 
         SuperscriptBox["c", "2"], "-", 
         RowBox[{"2", " ", "S"}]}], ")"}]}], "+", 
      RowBox[{"6", " ", 
       SuperscriptBox["c", "4"], " ", "S"}], "+", 
      RowBox[{
       SuperscriptBox["b", "4"], " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["c", "2"], "+", 
         RowBox[{"2", " ", "S"}]}], ")"}]}], "+", 
      RowBox[{
       SuperscriptBox["a", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"3", " ", 
          SuperscriptBox["b", "4"]}], "+", 
         RowBox[{
          SuperscriptBox["b", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"6", " ", 
             SuperscriptBox["c", "2"]}], "-", 
            RowBox[{"8", " ", "S"}]}], ")"}]}], "+", 
         RowBox[{"3", " ", 
          RowBox[{"(", 
           RowBox[{
            SuperscriptBox["c", "4"], "-", 
            RowBox[{"4", " ", 
             SuperscriptBox["c", "2"], " ", "S"}]}], ")"}]}]}], ")"}]}]}]}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"-", "3"}], " ", 
       SuperscriptBox["a", "6"]}], "-", 
      RowBox[{"3", " ", 
       SuperscriptBox["b", "6"]}], "-", 
      RowBox[{"9", " ", 
       SuperscriptBox["b", "2"], " ", 
       SuperscriptBox["c", "4"]}], "+", 
      RowBox[{"3", " ", 
       SuperscriptBox["c", "6"]}], "+", 
      RowBox[{
       SuperscriptBox["b", "4"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"9", " ", 
          SuperscriptBox["c", "2"]}], "-", 
         RowBox[{"2", " ", "S"}]}], ")"}]}], "+", 
      RowBox[{"2", " ", 
       SuperscriptBox["c", "4"], " ", "S"}], "+", 
      RowBox[{
       SuperscriptBox["a", "4"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", 
          SuperscriptBox["b", "2"]}], "+", 
         RowBox[{"9", " ", 
          SuperscriptBox["c", "2"]}], "+", 
         RowBox[{"2", " ", "S"}]}], ")"}]}], "+", 
      RowBox[{
       SuperscriptBox["a", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"3", " ", 
          SuperscriptBox["b", "4"]}], "-", 
         RowBox[{"9", " ", 
          SuperscriptBox["c", "4"]}], "+", 
         RowBox[{"2", " ", 
          SuperscriptBox["b", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"5", " ", 
             SuperscriptBox["c", "2"]}], "-", 
            RowBox[{"4", " ", "S"}]}], ")"}]}], "-", 
         RowBox[{"4", " ", 
          SuperscriptBox["c", "2"], " ", "S"}]}], ")"}]}]}], ",", 
     RowBox[{
      RowBox[{"-", "2"}], " ", 
      RowBox[{"(", 
       RowBox[{"a", "-", "c"}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{"a", "+", "c"}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "4"], "+", 
        SuperscriptBox["c", "4"], "-", 
        RowBox[{
         SuperscriptBox["b", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["c", "2"], "-", 
           RowBox[{"4", " ", "S"}]}], ")"}]}], "-", 
        RowBox[{"2", " ", 
         SuperscriptBox["c", "2"], " ", "S"}], "+", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"-", "3"}], " ", 
            SuperscriptBox["b", "2"]}], "-", 
           RowBox[{"2", " ", 
            SuperscriptBox["c", "2"]}], "+", 
           RowBox[{"2", " ", "S"}]}], ")"}]}]}], ")"}]}], ",", 
     RowBox[{
      SuperscriptBox["a", "6"], "-", 
      RowBox[{"3", " ", 
       SuperscriptBox["b", "6"]}], "-", 
      SuperscriptBox["c", "6"], "+", 
      RowBox[{
       SuperscriptBox["b", "4"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"7", " ", 
          SuperscriptBox["c", "2"]}], "-", 
         RowBox[{"2", " ", "S"}]}], ")"}]}], "+", 
      RowBox[{"2", " ", 
       SuperscriptBox["c", "4"], " ", "S"}], "+", 
      RowBox[{
       SuperscriptBox["a", "4"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"-", "3"}], " ", 
          SuperscriptBox["b", "2"]}], "-", 
         RowBox[{"3", " ", 
          SuperscriptBox["c", "2"]}], "+", 
         RowBox[{"2", " ", "S"}]}], ")"}]}], "+", 
      RowBox[{
       SuperscriptBox["a", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"5", " ", 
          SuperscriptBox["b", "4"]}], "+", 
         RowBox[{"3", " ", 
          SuperscriptBox["c", "4"]}], "+", 
         RowBox[{
          SuperscriptBox["b", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"6", " ", 
             SuperscriptBox["c", "2"]}], "-", 
            RowBox[{"4", " ", "S"}]}], ")"}]}], "-", 
         RowBox[{"4", " ", 
          SuperscriptBox["c", "2"], " ", "S"}]}], ")"}]}], "-", 
      RowBox[{
       SuperscriptBox["b", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"3", " ", 
          SuperscriptBox["c", "4"]}], "+", 
         RowBox[{"4", " ", 
          SuperscriptBox["c", "2"], " ", "S"}]}], ")"}]}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", 
       SuperscriptBox["a", "6"]}], "-", 
      RowBox[{"3", " ", 
       SuperscriptBox["b", "6"]}], "+", 
      SuperscriptBox["c", "6"], "+", 
      RowBox[{
       SuperscriptBox["b", "4"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"5", " ", 
          SuperscriptBox["c", "2"]}], "-", 
         RowBox[{"2", " ", "S"}]}], ")"}]}], "+", 
      RowBox[{"2", " ", 
       SuperscriptBox["c", "4"], " ", "S"}], "+", 
      RowBox[{
       SuperscriptBox["a", "4"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"-", "3"}], " ", 
          SuperscriptBox["b", "2"]}], "+", 
         RowBox[{"3", " ", 
          SuperscriptBox["c", "2"]}], "+", 
         RowBox[{"2", " ", "S"}]}], ")"}]}], "+", 
      RowBox[{
       SuperscriptBox["a", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"7", " ", 
          SuperscriptBox["b", "4"]}], "-", 
         RowBox[{"3", " ", 
          SuperscriptBox["c", "4"]}], "+", 
         RowBox[{
          SuperscriptBox["b", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"6", " ", 
             SuperscriptBox["c", "2"]}], "-", 
            RowBox[{"4", " ", "S"}]}], ")"}]}], "-", 
         RowBox[{"4", " ", 
          SuperscriptBox["c", "2"], " ", "S"}]}], ")"}]}], "-", 
      RowBox[{
       SuperscriptBox["b", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"3", " ", 
          SuperscriptBox["c", "4"]}], "+", 
         RowBox[{"4", " ", 
          SuperscriptBox["c", "2"], " ", "S"}]}], ")"}]}]}], ",", 
     RowBox[{"2", " ", 
      RowBox[{"(", 
       RowBox[{"a", "-", "c"}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{"a", "+", "c"}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "4"], "+", 
        SuperscriptBox["c", "4"], "+", 
        RowBox[{"2", " ", 
         SuperscriptBox["c", "2"], " ", "S"}], "+", 
        RowBox[{
         SuperscriptBox["b", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"-", "3"}], " ", 
            SuperscriptBox["c", "2"]}], "+", 
           RowBox[{"4", " ", "S"}]}], ")"}]}], "-", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "2"], "+", 
           RowBox[{"2", " ", 
            RowBox[{"(", 
             RowBox[{
              SuperscriptBox["c", "2"], "+", "S"}], ")"}]}]}], ")"}]}]}], 
       ")"}]}], ",", 
     RowBox[{
      RowBox[{"3", " ", 
       SuperscriptBox["a", "6"]}], "-", 
      RowBox[{"3", " ", 
       SuperscriptBox["b", "6"]}], "-", 
      RowBox[{"3", " ", 
       SuperscriptBox["c", "6"]}], "+", 
      RowBox[{
       SuperscriptBox["b", "4"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"3", " ", 
          SuperscriptBox["c", "2"]}], "-", 
         RowBox[{"2", " ", "S"}]}], ")"}]}], "+", 
      RowBox[{"2", " ", 
       SuperscriptBox["c", "4"], " ", "S"}], "+", 
      RowBox[{
       SuperscriptBox["a", "4"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"-", "9"}], " ", 
          SuperscriptBox["b", "2"]}], "-", 
         RowBox[{"9", " ", 
          SuperscriptBox["c", "2"]}], "+", 
         RowBox[{"2", " ", "S"}]}], ")"}]}], "+", 
      RowBox[{
       SuperscriptBox["a", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"9", " ", 
          SuperscriptBox["b", "4"]}], "+", 
         RowBox[{"10", " ", 
          SuperscriptBox["b", "2"], " ", 
          SuperscriptBox["c", "2"]}], "+", 
         RowBox[{"9", " ", 
          SuperscriptBox["c", "4"]}], "-", 
         RowBox[{"4", " ", 
          SuperscriptBox["c", "2"], " ", "S"}]}], ")"}]}], "-", 
      RowBox[{
       SuperscriptBox["b", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["c", "4"], "+", 
         RowBox[{"8", " ", 
          SuperscriptBox["c", "2"], " ", "S"}]}], ")"}]}]}]}], "}"}]}], 
  "}"}]], "Output",
 CellChangeTimes->{3.954734617198675*^9, 3.954734816513953*^9, 
  3.9547348978013387`*^9, 3.9547456202139783`*^9, 3.954745705154098*^9, 
  3.954746221829569*^9, 3.954747260051348*^9, 3.954747694515775*^9, 
  3.9547581196008162`*^9, 3.9547583599511127`*^9, 3.954758413053156*^9, 
  3.9611231229685364`*^9, 3.96141296570907*^9},
 CellLabel->
  "Out[291]=",ExpressionUUID->"c2f43cc2-c4df-4c6d-bea1-adf921b8df08"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"orthodiagonalQuadQ", "[", 
  RowBox[{"{", 
   RowBox[{"ptF", ",", "ptG", ",", "ptH", ",", "ptI"}], "}"}], "]"}]], "Input",
 CellChangeTimes->{{3.9547581609478846`*^9, 3.954758162349493*^9}},
 CellLabel->
  "In[292]:=",ExpressionUUID->"aaafa899-1bc1-0243-8905-f3f5a463e84b"],

Cell[BoxData["True"], "Output",
 CellChangeTimes->{3.954758166997286*^9, 3.954758265104833*^9, 
  3.95475831942744*^9, 3.954758366168917*^9, 3.954758419036211*^9, 
  3.961123128813406*^9, 3.961412967015512*^9},
 CellLabel->
  "Out[292]=",ExpressionUUID->"195f9901-1427-4da1-8470-594e1418cc2c"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["X (642)", "Subsection",
 CellChangeTimes->{{3.9547318899015656`*^9, 3.954731893974074*^9}, {
   3.95473265785647*^9, 3.954732659663503*^9}, {3.954732890679308*^9, 
   3.954732891487614*^9}, 3.954733054504549*^9, 3.954734909088499*^9, {
   3.9547456826790233`*^9, 3.954745683267832*^9}, {3.954746186388487*^9, 
   3.9547461864024734`*^9}, {3.9547472494340367`*^9, 
   3.9547472496864853`*^9}, {3.9547584031954937`*^9, 
   3.9547584032740726`*^9}, {3.954758439994835*^9, 
   3.9547584408594646`*^9}},ExpressionUUID->"c76dcc49-5055-ed45-960f-\
2079d27a3b0e"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"X642", "=", 
  RowBox[{"Simplificar", "[", 
   RowBox[{
    RowBox[{"Expand", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"ETC", "[", 
        RowBox[{"[", 
         RowBox[{"642", ",", "2"}], "]"}], "]"}], "/.", "sustS"}], "/.", 
      "sustC"}], "]"}], "/.", "sustS"}], "]"}]}]], "Input",
 CellChangeTimes->{{3.954747610010666*^9, 3.954747684007263*^9}, {
  3.954758407141165*^9, 3.954758407198597*^9}, {3.954758447644256*^9, 
  3.95475844990834*^9}, {3.961123186752138*^9, 3.961123189582905*^9}},
 CellLabel->
  "In[293]:=",ExpressionUUID->"5d41aa62-3709-f14f-9c76-e3eb2c2e9f8b"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"-", "2"}], " ", 
     SuperscriptBox["a", "4"]}], "-", 
    SuperscriptBox["b", "4"], "+", 
    RowBox[{"3", " ", 
     SuperscriptBox["a", "2"], " ", 
     RowBox[{"(", 
      RowBox[{
       SuperscriptBox["b", "2"], "+", 
       SuperscriptBox["c", "2"]}], ")"}]}], "+", 
    RowBox[{"2", " ", 
     SuperscriptBox["b", "2"], " ", 
     RowBox[{"(", 
      RowBox[{
       SuperscriptBox["c", "2"], "-", "S"}], ")"}]}], "-", 
    RowBox[{
     SuperscriptBox["c", "2"], " ", 
     RowBox[{"(", 
      RowBox[{
       SuperscriptBox["c", "2"], "+", 
       RowBox[{"2", " ", "S"}]}], ")"}]}]}], ",", 
   RowBox[{
    RowBox[{"-", 
     SuperscriptBox["a", "4"]}], "-", 
    RowBox[{"2", " ", 
     SuperscriptBox["b", "4"]}], "+", 
    RowBox[{"3", " ", 
     SuperscriptBox["b", "2"], " ", 
     SuperscriptBox["c", "2"]}], "+", 
    RowBox[{
     SuperscriptBox["a", "2"], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"3", " ", 
        SuperscriptBox["b", "2"]}], "+", 
       RowBox[{"2", " ", 
        SuperscriptBox["c", "2"]}], "-", 
       RowBox[{"2", " ", "S"}]}], ")"}]}], "-", 
    RowBox[{
     SuperscriptBox["c", "2"], " ", 
     RowBox[{"(", 
      RowBox[{
       SuperscriptBox["c", "2"], "+", 
       RowBox[{"2", " ", "S"}]}], ")"}]}]}], ",", 
   RowBox[{
    RowBox[{"-", 
     SuperscriptBox["a", "4"]}], "-", 
    SuperscriptBox["b", "4"], "-", 
    RowBox[{"2", " ", 
     SuperscriptBox["c", "4"]}], "+", 
    RowBox[{
     SuperscriptBox["b", "2"], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"3", " ", 
        SuperscriptBox["c", "2"]}], "-", 
       RowBox[{"2", " ", "S"}]}], ")"}]}], "+", 
    RowBox[{
     SuperscriptBox["a", "2"], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"2", " ", 
        SuperscriptBox["b", "2"]}], "+", 
       RowBox[{"3", " ", 
        SuperscriptBox["c", "2"]}], "-", 
       RowBox[{"2", " ", "S"}]}], ")"}]}]}]}], "}"}]], "Output",
 CellChangeTimes->{
  3.954747619393961*^9, {3.9547476554628716`*^9, 3.9547476846845*^9}, 
   3.9547583570794487`*^9, 3.9547584082339993`*^9, 3.954758450196857*^9, 
   3.961123192278965*^9, 3.961412967090352*^9},
 CellLabel->
  "Out[293]=",ExpressionUUID->"8d23ffa4-e458-40a7-956d-94075b1c5f64"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"{", 
    RowBox[{"ptF", ",", "ptG", ",", "ptH", ",", "ptI"}], "}"}], "=", 
   RowBox[{"Simplificar", "/@", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       RowBox[{"centralQuadrilateral", "[", 
        RowBox[{"X642", ",", "ptE"}], "]"}], "/.", "sustS"}], "/.", "sustC"}],
      ")"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"{", 
   RowBox[{"ptF", ",", "ptG", ",", "ptH", ",", "ptI"}], "}"}], "=", 
  RowBox[{
   RowBox[{
    RowBox[{"Simplificar", "[", 
     RowBox[{
      RowBox[{"Expand", "[", "#", "]"}], "/.", "sustS"}], "]"}], "&"}], "/@", 
   RowBox[{"{", 
    RowBox[{"ptF", ",", "ptG", ",", "ptH", ",", "ptI"}], "}"}]}]}]}], "Input",
 CellChangeTimes->{{3.954734614817431*^9, 3.954734615601975*^9}, 
   3.954745698225521*^9, {3.954746220639621*^9, 3.954746220703642*^9}, {
   3.954747257081831*^9, 3.954747257656212*^9}, {3.9547476915928345`*^9, 
   3.954747692511669*^9}, {3.954758099553793*^9, 3.954758117861986*^9}, {
   3.9611231966552334`*^9, 3.961123198751747*^9}},
 CellLabel->
  "In[294]:=",ExpressionUUID->"e7feb55e-d3c4-4c44-8204-16ff3e4fc5db"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", 
       SuperscriptBox["a", "8"]}], "+", 
      RowBox[{"4", " ", 
       SuperscriptBox["a", "6"], " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["b", "2"], "+", 
         SuperscriptBox["c", "2"]}], ")"}]}], "-", 
      RowBox[{"2", " ", 
       SuperscriptBox["a", "4"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"3", " ", 
          SuperscriptBox["c", "4"]}], "+", 
         RowBox[{"4", " ", 
          SuperscriptBox["b", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            SuperscriptBox["c", "2"], "+", "S"}], ")"}]}]}], ")"}]}], "+", 
      RowBox[{
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["b", "2"], "-", 
          SuperscriptBox["c", "2"]}], ")"}], "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["b", "4"], "-", 
         SuperscriptBox["c", "4"], "-", 
         RowBox[{"2", " ", 
          SuperscriptBox["b", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            SuperscriptBox["c", "2"], "+", 
            RowBox[{"2", " ", "S"}]}], ")"}]}]}], ")"}]}], "+", 
      RowBox[{"4", " ", 
       SuperscriptBox["a", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["c", "6"], "+", 
         RowBox[{
          SuperscriptBox["b", "4"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", 
             SuperscriptBox["c", "2"]}], "+", "S"}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["b", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            SuperscriptBox["c", "4"], "+", 
            RowBox[{"3", " ", 
             SuperscriptBox["c", "2"], " ", "S"}]}], ")"}]}]}], ")"}]}]}], ",", 
     RowBox[{
      SuperscriptBox["b", "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"5", " ", 
         SuperscriptBox["a", "6"]}], "+", 
        RowBox[{"3", " ", 
         SuperscriptBox["b", "6"]}], "-", 
        RowBox[{"5", " ", 
         SuperscriptBox["c", "6"]}], "+", 
        RowBox[{"2", " ", 
         SuperscriptBox["c", "4"], " ", "S"}], "+", 
        RowBox[{
         SuperscriptBox["a", "4"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"-", "9"}], " ", 
            SuperscriptBox["b", "2"]}], "-", 
           RowBox[{"15", " ", 
            SuperscriptBox["c", "2"]}], "+", 
           RowBox[{"2", " ", "S"}]}], ")"}]}], "-", 
        RowBox[{
         SuperscriptBox["b", "4"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"9", " ", 
            SuperscriptBox["c", "2"]}], "+", 
           RowBox[{"2", " ", "S"}]}], ")"}]}], "+", 
        RowBox[{
         SuperscriptBox["b", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"11", " ", 
            SuperscriptBox["c", "4"]}], "-", 
           RowBox[{"4", " ", 
            SuperscriptBox["c", "2"], " ", "S"}]}], ")"}]}], "+", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"-", "3"}], " ", 
            SuperscriptBox["b", "4"]}], "+", 
           RowBox[{"15", " ", 
            SuperscriptBox["c", "4"]}], "-", 
           RowBox[{"2", " ", 
            SuperscriptBox["b", "2"], " ", 
            RowBox[{"(", 
             RowBox[{
              SuperscriptBox["c", "2"], "-", 
              RowBox[{"10", " ", "S"}]}], ")"}]}], "-", 
           RowBox[{"4", " ", 
            SuperscriptBox["c", "2"], " ", "S"}]}], ")"}]}]}], ")"}]}], ",", 
     RowBox[{
      SuperscriptBox["a", "8"], "+", 
      SuperscriptBox["c", "8"], "-", 
      RowBox[{
       SuperscriptBox["a", "6"], " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["b", "2"], "+", 
         RowBox[{"4", " ", 
          SuperscriptBox["c", "2"]}]}], ")"}]}], "+", 
      RowBox[{
       SuperscriptBox["a", "4"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"-", "3"}], " ", 
          SuperscriptBox["b", "4"]}], "+", 
         RowBox[{"6", " ", 
          SuperscriptBox["c", "4"]}], "-", 
         RowBox[{
          SuperscriptBox["b", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            SuperscriptBox["c", "2"], "-", 
            RowBox[{"6", " ", "S"}]}], ")"}]}]}], ")"}]}], "-", 
      RowBox[{
       SuperscriptBox["b", "6"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"3", " ", 
          SuperscriptBox["c", "2"]}], "+", 
         RowBox[{"2", " ", "S"}]}], ")"}]}], "+", 
      RowBox[{
       SuperscriptBox["b", "4"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"5", " ", 
          SuperscriptBox["c", "4"]}], "+", 
         RowBox[{"4", " ", 
          SuperscriptBox["c", "2"], " ", "S"}]}], ")"}]}], "+", 
      RowBox[{
       SuperscriptBox["b", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"-", "3"}], " ", 
          SuperscriptBox["c", "6"]}], "+", 
         RowBox[{"2", " ", 
          SuperscriptBox["c", "4"], " ", "S"}]}], ")"}]}], "+", 
      RowBox[{
       SuperscriptBox["a", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"3", " ", 
          SuperscriptBox["b", "6"]}], "-", 
         RowBox[{"2", " ", 
          SuperscriptBox["b", "4"], " ", 
          SuperscriptBox["c", "2"]}], "-", 
         RowBox[{"4", " ", 
          SuperscriptBox["c", "6"]}], "+", 
         RowBox[{
          SuperscriptBox["b", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"5", " ", 
             SuperscriptBox["c", "4"]}], "-", 
            RowBox[{"8", " ", 
             SuperscriptBox["c", "2"], " ", "S"}]}], ")"}]}]}], ")"}]}]}]}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      SuperscriptBox["a", "8"], "-", 
      RowBox[{"3", " ", 
       SuperscriptBox["b", "4"], " ", 
       SuperscriptBox["c", "4"]}], "+", 
      SuperscriptBox["c", "8"], "-", 
      RowBox[{
       SuperscriptBox["a", "6"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"3", " ", 
          SuperscriptBox["b", "2"]}], "+", 
         RowBox[{"4", " ", 
          SuperscriptBox["c", "2"]}]}], ")"}]}], "+", 
      RowBox[{
       SuperscriptBox["b", "6"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"3", " ", 
          SuperscriptBox["c", "2"]}], "-", 
         RowBox[{"2", " ", "S"}]}], ")"}]}], "-", 
      RowBox[{
       SuperscriptBox["b", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["c", "6"], "-", 
         RowBox[{"6", " ", 
          SuperscriptBox["c", "4"], " ", "S"}]}], ")"}]}], "+", 
      RowBox[{
       SuperscriptBox["a", "4"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"5", " ", 
          SuperscriptBox["b", "4"]}], "+", 
         RowBox[{"6", " ", 
          SuperscriptBox["c", "4"]}], "+", 
         RowBox[{
          SuperscriptBox["b", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"5", " ", 
             SuperscriptBox["c", "2"]}], "+", 
            RowBox[{"2", " ", "S"}]}], ")"}]}]}], ")"}]}], "-", 
      RowBox[{
       SuperscriptBox["a", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"3", " ", 
          SuperscriptBox["b", "6"]}], "+", 
         RowBox[{"4", " ", 
          SuperscriptBox["c", "6"]}], "+", 
         RowBox[{"2", " ", 
          SuperscriptBox["b", "4"], " ", 
          RowBox[{"(", 
           RowBox[{
            SuperscriptBox["c", "2"], "-", 
            RowBox[{"2", " ", "S"}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["b", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            SuperscriptBox["c", "4"], "+", 
            RowBox[{"8", " ", 
             SuperscriptBox["c", "2"], " ", "S"}]}], ")"}]}]}], ")"}]}]}], ",", 
     RowBox[{
      SuperscriptBox["b", "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"-", "5"}], " ", 
         SuperscriptBox["a", "6"]}], "+", 
        RowBox[{"3", " ", 
         SuperscriptBox["b", "6"]}], "+", 
        RowBox[{"5", " ", 
         SuperscriptBox["c", "6"]}], "+", 
        RowBox[{"2", " ", 
         SuperscriptBox["c", "4"], " ", "S"}], "-", 
        RowBox[{
         SuperscriptBox["b", "4"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"3", " ", 
            SuperscriptBox["c", "2"]}], "+", 
           RowBox[{"2", " ", "S"}]}], ")"}]}], "+", 
        RowBox[{
         SuperscriptBox["a", "4"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"11", " ", 
            SuperscriptBox["b", "2"]}], "+", 
           RowBox[{"15", " ", 
            SuperscriptBox["c", "2"]}], "+", 
           RowBox[{"2", " ", "S"}]}], ")"}]}], "+", 
        RowBox[{
         SuperscriptBox["b", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"-", "9"}], " ", 
            SuperscriptBox["c", "4"]}], "+", 
           RowBox[{"20", " ", 
            SuperscriptBox["c", "2"], " ", "S"}]}], ")"}]}], "-", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"9", " ", 
            SuperscriptBox["b", "4"]}], "+", 
           RowBox[{"15", " ", 
            SuperscriptBox["c", "4"]}], "+", 
           RowBox[{"4", " ", 
            SuperscriptBox["c", "2"], " ", "S"}], "+", 
           RowBox[{"2", " ", 
            SuperscriptBox["b", "2"], " ", 
            RowBox[{"(", 
             RowBox[{
              SuperscriptBox["c", "2"], "+", 
              RowBox[{"2", " ", "S"}]}], ")"}]}]}], ")"}]}]}], ")"}]}], ",", 
     RowBox[{
      RowBox[{"-", 
       SuperscriptBox["a", "8"]}], "+", 
      SuperscriptBox["b", "8"], "+", 
      RowBox[{"4", " ", 
       SuperscriptBox["a", "6"], " ", 
       SuperscriptBox["c", "2"]}], "-", 
      SuperscriptBox["c", "8"], "+", 
      RowBox[{
       SuperscriptBox["a", "4"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"4", " ", 
          SuperscriptBox["b", "4"]}], "-", 
         RowBox[{"6", " ", 
          SuperscriptBox["c", "4"]}], "+", 
         RowBox[{"4", " ", 
          SuperscriptBox["b", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            SuperscriptBox["c", "2"], "-", "S"}], ")"}]}]}], ")"}]}], "-", 
      RowBox[{"4", " ", 
       SuperscriptBox["b", "6"], " ", "S"}], "+", 
      RowBox[{"4", " ", 
       SuperscriptBox["b", "4"], " ", 
       SuperscriptBox["c", "2"], " ", "S"}], "+", 
      RowBox[{"4", " ", 
       SuperscriptBox["b", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["c", "6"], "-", 
         RowBox[{"2", " ", 
          SuperscriptBox["c", "4"], " ", "S"}]}], ")"}]}], "-", 
      RowBox[{"4", " ", 
       SuperscriptBox["a", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["b", "6"], "-", 
         SuperscriptBox["c", "6"], "+", 
         RowBox[{
          SuperscriptBox["b", "4"], " ", 
          RowBox[{"(", 
           RowBox[{
            SuperscriptBox["c", "2"], "-", 
            RowBox[{"2", " ", "S"}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["b", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"2", " ", 
             SuperscriptBox["c", "4"]}], "-", 
            RowBox[{"3", " ", 
             SuperscriptBox["c", "2"], " ", "S"}]}], ")"}]}]}], ")"}]}]}]}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"2", " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         SuperscriptBox["a", "8"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"3", " ", 
            SuperscriptBox["b", "2"]}], "-", "S"}], ")"}]}], "+", 
        RowBox[{
         SuperscriptBox["a", "6"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"-", "3"}], " ", 
            SuperscriptBox["b", "4"]}], "+", 
           RowBox[{"4", " ", 
            SuperscriptBox["c", "2"], " ", "S"}], "+", 
           RowBox[{
            SuperscriptBox["b", "2"], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               RowBox[{"-", "11"}], " ", 
               SuperscriptBox["c", "2"]}], "+", 
              RowBox[{"2", " ", "S"}]}], ")"}]}]}], ")"}]}], "+", 
        RowBox[{
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{
            SuperscriptBox["b", "2"], "-", 
            SuperscriptBox["c", "2"]}], ")"}], "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"2", " ", 
            SuperscriptBox["b", "6"]}], "+", 
           RowBox[{"2", " ", 
            SuperscriptBox["b", "2"], " ", 
            SuperscriptBox["c", "4"]}], "-", 
           RowBox[{
            SuperscriptBox["c", "4"], " ", "S"}], "+", 
           RowBox[{
            SuperscriptBox["b", "4"], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               RowBox[{"-", "4"}], " ", 
               SuperscriptBox["c", "2"]}], "+", 
              RowBox[{"3", " ", "S"}]}], ")"}]}]}], ")"}]}], "-", 
        RowBox[{
         SuperscriptBox["a", "4"], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "6"], "+", 
           RowBox[{"2", " ", 
            SuperscriptBox["b", "4"], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"3", " ", 
               SuperscriptBox["c", "2"]}], "-", 
              RowBox[{"5", " ", "S"}]}], ")"}]}], "+", 
           RowBox[{"6", " ", 
            SuperscriptBox["c", "4"], " ", "S"}], "+", 
           RowBox[{
            SuperscriptBox["b", "2"], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               RowBox[{"-", "15"}], " ", 
               SuperscriptBox["c", "4"]}], "+", 
              RowBox[{"2", " ", 
               SuperscriptBox["c", "2"], " ", "S"}]}], ")"}]}]}], ")"}]}], "-", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "8"], "+", 
           RowBox[{
            SuperscriptBox["b", "6"], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"7", " ", 
               SuperscriptBox["c", "2"]}], "-", 
              RowBox[{"6", " ", "S"}]}], ")"}]}], "-", 
           RowBox[{"4", " ", 
            SuperscriptBox["c", "6"], " ", "S"}], "+", 
           RowBox[{
            SuperscriptBox["b", "4"], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               RowBox[{"-", "17"}], " ", 
               SuperscriptBox["c", "4"]}], "+", 
              RowBox[{"12", " ", 
               SuperscriptBox["c", "2"], " ", "S"}]}], ")"}]}], "+", 
           RowBox[{
            SuperscriptBox["b", "2"], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"9", " ", 
               SuperscriptBox["c", "6"]}], "+", 
              RowBox[{"2", " ", 
               SuperscriptBox["c", "4"], " ", "S"}]}], ")"}]}]}], ")"}]}]}], 
       ")"}]}], ",", 
     RowBox[{
      RowBox[{"-", 
       SuperscriptBox["b", "2"]}], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "8"], "+", 
        RowBox[{"2", " ", 
         SuperscriptBox["a", "6"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"8", " ", 
            SuperscriptBox["b", "2"]}], "-", 
           RowBox[{"2", " ", 
            SuperscriptBox["c", "2"]}], "-", 
           RowBox[{"5", " ", "S"}]}], ")"}]}], "+", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"-", "4"}], " ", 
            SuperscriptBox["b", "6"]}], "-", 
           RowBox[{"4", " ", 
            SuperscriptBox["c", "6"]}], "-", 
           RowBox[{"30", " ", 
            SuperscriptBox["c", "4"], " ", "S"}], "+", 
           RowBox[{"20", " ", 
            SuperscriptBox["b", "2"], " ", 
            SuperscriptBox["c", "2"], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"2", " ", 
               SuperscriptBox["c", "2"]}], "+", "S"}], ")"}]}], "+", 
           RowBox[{
            SuperscriptBox["b", "4"], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               RowBox[{"-", "40"}], " ", 
               SuperscriptBox["c", "2"]}], "+", 
              RowBox[{"46", " ", "S"}]}], ")"}]}]}], ")"}]}], "+", 
        RowBox[{
         SuperscriptBox["a", "4"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"-", "24"}], " ", 
            SuperscriptBox["b", "4"]}], "+", 
           RowBox[{
            SuperscriptBox["b", "2"], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               RowBox[{"-", "44"}], " ", 
               SuperscriptBox["c", "2"]}], "+", 
              RowBox[{"10", " ", "S"}]}], ")"}]}], "+", 
           RowBox[{"6", " ", 
            RowBox[{"(", 
             RowBox[{
              SuperscriptBox["c", "4"], "+", 
              RowBox[{"5", " ", 
               SuperscriptBox["c", "2"], " ", "S"}]}], ")"}]}]}], ")"}]}], "+", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "2"], "-", 
           SuperscriptBox["c", "2"]}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"11", " ", 
            SuperscriptBox["b", "6"]}], "-", 
           RowBox[{"3", " ", 
            SuperscriptBox["b", "4"], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"7", " ", 
               SuperscriptBox["c", "2"]}], "+", 
              RowBox[{"2", " ", "S"}]}], ")"}]}], "-", 
           RowBox[{
            SuperscriptBox["c", "4"], " ", 
            RowBox[{"(", 
             RowBox[{
              SuperscriptBox["c", "2"], "+", 
              RowBox[{"10", " ", "S"}]}], ")"}]}], "+", 
           RowBox[{
            SuperscriptBox["b", "2"], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"11", " ", 
               SuperscriptBox["c", "4"]}], "+", 
              RowBox[{"20", " ", 
               SuperscriptBox["c", "2"], " ", "S"}]}], ")"}]}]}], ")"}]}]}], 
       ")"}]}], ",", 
     RowBox[{
      RowBox[{
       SuperscriptBox["a", "8"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"-", "5"}], " ", 
          SuperscriptBox["b", "2"]}], "+", 
         RowBox[{"2", " ", "S"}]}], ")"}]}], "+", 
      RowBox[{"2", " ", 
       SuperscriptBox["a", "6"], " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["b", "4"], "-", 
         RowBox[{"4", " ", 
          SuperscriptBox["c", "2"], " ", "S"}], "+", 
         RowBox[{
          SuperscriptBox["b", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"9", " ", 
             SuperscriptBox["c", "2"]}], "+", "S"}], ")"}]}]}], ")"}]}], "+", 
      RowBox[{"2", " ", 
       SuperscriptBox["a", "4"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"7", " ", 
          SuperscriptBox["b", "6"]}], "+", 
         RowBox[{
          SuperscriptBox["b", "4"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"6", " ", 
             SuperscriptBox["c", "2"]}], "-", 
            RowBox[{"9", " ", "S"}]}], ")"}]}], "+", 
         RowBox[{"6", " ", 
          SuperscriptBox["c", "4"], " ", "S"}], "-", 
         RowBox[{
          SuperscriptBox["b", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"12", " ", 
             SuperscriptBox["c", "4"]}], "+", 
            RowBox[{"7", " ", 
             SuperscriptBox["c", "2"], " ", "S"}]}], ")"}]}]}], ")"}]}], "+", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["b", "2"], "-", 
         SuperscriptBox["c", "2"]}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"3", " ", 
          SuperscriptBox["b", "8"]}], "-", 
         RowBox[{
          SuperscriptBox["b", "6"], " ", 
          RowBox[{"(", 
           RowBox[{
            SuperscriptBox["c", "2"], "-", 
            RowBox[{"12", " ", "S"}]}], ")"}]}], "-", 
         RowBox[{"2", " ", 
          SuperscriptBox["c", "6"], " ", "S"}], "-", 
         RowBox[{
          SuperscriptBox["b", "4"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"5", " ", 
             SuperscriptBox["c", "4"]}], "+", 
            RowBox[{"14", " ", 
             SuperscriptBox["c", "2"], " ", "S"}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["b", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"3", " ", 
             SuperscriptBox["c", "6"]}], "+", 
            RowBox[{"8", " ", 
             SuperscriptBox["c", "4"], " ", "S"}]}], ")"}]}]}], ")"}]}], "-", 
      RowBox[{"2", " ", 
       SuperscriptBox["a", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"7", " ", 
          SuperscriptBox["b", "8"]}], "+", 
         RowBox[{"4", " ", 
          SuperscriptBox["c", "6"], " ", "S"}], "-", 
         RowBox[{
          SuperscriptBox["b", "6"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"7", " ", 
             SuperscriptBox["c", "2"]}], "+", "S"}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["b", "4"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"11", " ", 
             SuperscriptBox["c", "4"]}], "+", 
            RowBox[{"2", " ", 
             SuperscriptBox["c", "2"], " ", "S"}]}], ")"}]}], "-", 
         RowBox[{
          SuperscriptBox["b", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"7", " ", 
             SuperscriptBox["c", "6"]}], "+", 
            RowBox[{"11", " ", 
             SuperscriptBox["c", "4"], " ", "S"}]}], ")"}]}]}], ")"}]}]}]}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{
       SuperscriptBox["a", "8"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"-", "3"}], " ", 
          SuperscriptBox["b", "2"]}], "+", 
         RowBox[{"2", " ", "S"}]}], ")"}]}], "+", 
      RowBox[{"2", " ", 
       SuperscriptBox["a", "6"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"4", " ", 
          SuperscriptBox["b", "4"]}], "+", 
         RowBox[{
          SuperscriptBox["b", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"7", " ", 
             SuperscriptBox["c", "2"]}], "-", 
            RowBox[{"5", " ", "S"}]}], ")"}]}], "-", 
         RowBox[{"4", " ", 
          SuperscriptBox["c", "2"], " ", "S"}]}], ")"}]}], "+", 
      RowBox[{
       SuperscriptBox["a", "4"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"-", "4"}], " ", 
          SuperscriptBox["b", "6"]}], "-", 
         RowBox[{"22", " ", 
          SuperscriptBox["b", "4"], " ", 
          RowBox[{"(", 
           RowBox[{
            SuperscriptBox["c", "2"], "-", "S"}], ")"}]}], "+", 
         RowBox[{"12", " ", 
          SuperscriptBox["c", "4"], " ", "S"}], "+", 
         RowBox[{
          SuperscriptBox["b", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"-", "24"}], " ", 
             SuperscriptBox["c", "4"]}], "+", 
            RowBox[{"22", " ", 
             SuperscriptBox["c", "2"], " ", "S"}]}], ")"}]}]}], ")"}]}], "+", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["b", "2"], "-", 
         SuperscriptBox["c", "2"]}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"3", " ", 
          SuperscriptBox["b", "8"]}], "-", 
         RowBox[{"2", " ", 
          SuperscriptBox["c", "6"], " ", "S"}], "+", 
         RowBox[{
          SuperscriptBox["b", "6"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"-", "11"}], " ", 
             SuperscriptBox["c", "2"]}], "+", 
            RowBox[{"12", " ", "S"}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["b", "4"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"3", " ", 
             SuperscriptBox["c", "4"]}], "+", 
            RowBox[{"14", " ", 
             SuperscriptBox["c", "2"], " ", "S"}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["b", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"5", " ", 
             SuperscriptBox["c", "6"]}], "-", 
            RowBox[{"4", " ", 
             SuperscriptBox["c", "4"], " ", "S"}]}], ")"}]}]}], ")"}]}], "-", 
      RowBox[{"2", " ", 
       SuperscriptBox["a", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"2", " ", 
          SuperscriptBox["b", "8"]}], "+", 
         RowBox[{"4", " ", 
          SuperscriptBox["c", "6"], " ", "S"}], "+", 
         RowBox[{
          SuperscriptBox["b", "6"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"-", "7"}], " ", 
             SuperscriptBox["c", "2"]}], "+", 
            RowBox[{"13", " ", "S"}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["b", "4"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"-", "6"}], " ", 
             SuperscriptBox["c", "4"]}], "+", 
            RowBox[{"2", " ", 
             SuperscriptBox["c", "2"], " ", "S"}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["b", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"-", "9"}], " ", 
             SuperscriptBox["c", "6"]}], "+", 
            RowBox[{"7", " ", 
             SuperscriptBox["c", "4"], " ", "S"}]}], ")"}]}]}], ")"}]}]}], ",", 
     RowBox[{
      RowBox[{"-", 
       SuperscriptBox["b", "2"]}], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "8"], "+", 
        RowBox[{"11", " ", 
         SuperscriptBox["b", "8"]}], "+", 
        SuperscriptBox["c", "8"], "-", 
        RowBox[{"2", " ", 
         SuperscriptBox["a", "6"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"6", " ", 
            SuperscriptBox["b", "2"]}], "+", 
           RowBox[{"2", " ", 
            SuperscriptBox["c", "2"]}], "-", 
           RowBox[{"5", " ", "S"}]}], ")"}]}], "-", 
        RowBox[{"10", " ", 
         SuperscriptBox["c", "6"], " ", "S"}], "-", 
        RowBox[{"2", " ", 
         SuperscriptBox["b", "6"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"2", " ", 
            SuperscriptBox["c", "2"]}], "+", 
           RowBox[{"3", " ", "S"}]}], ")"}]}], "+", 
        RowBox[{
         SuperscriptBox["b", "4"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"-", "24"}], " ", 
            SuperscriptBox["c", "4"]}], "+", 
           RowBox[{"46", " ", 
            SuperscriptBox["c", "2"], " ", "S"}]}], ")"}]}], "+", 
        RowBox[{"2", " ", 
         SuperscriptBox["b", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"8", " ", 
            SuperscriptBox["c", "6"]}], "+", 
           RowBox[{"5", " ", 
            SuperscriptBox["c", "4"], " ", "S"}]}], ")"}]}], "+", 
        RowBox[{
         SuperscriptBox["a", "4"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"32", " ", 
            SuperscriptBox["b", "4"]}], "+", 
           RowBox[{"10", " ", 
            SuperscriptBox["b", "2"], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"4", " ", 
               SuperscriptBox["c", "2"]}], "-", 
              RowBox[{"3", " ", "S"}]}], ")"}]}], "+", 
           RowBox[{"6", " ", 
            RowBox[{"(", 
             RowBox[{
              SuperscriptBox["c", "4"], "-", 
              RowBox[{"5", " ", 
               SuperscriptBox["c", "2"], " ", "S"}]}], ")"}]}]}], ")"}]}], "+", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"-", "32"}], " ", 
            SuperscriptBox["b", "6"]}], "-", 
           RowBox[{"4", " ", 
            SuperscriptBox["c", "6"]}], "+", 
           RowBox[{"30", " ", 
            SuperscriptBox["c", "4"], " ", "S"}], "+", 
           RowBox[{
            SuperscriptBox["b", "4"], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               RowBox[{"-", "40"}], " ", 
               SuperscriptBox["c", "2"]}], "+", 
              RowBox[{"26", " ", "S"}]}], ")"}]}], "+", 
           RowBox[{
            SuperscriptBox["b", "2"], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               RowBox[{"-", "44"}], " ", 
               SuperscriptBox["c", "4"]}], "+", 
              RowBox[{"20", " ", 
               SuperscriptBox["c", "2"], " ", "S"}]}], ")"}]}]}], ")"}]}]}], 
       ")"}]}], ",", 
     RowBox[{"2", " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"2", " ", 
         SuperscriptBox["b", "10"]}], "-", 
        RowBox[{
         SuperscriptBox["b", "8"], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["c", "2"], "-", 
           RowBox[{"3", " ", "S"}]}], ")"}]}], "+", 
        RowBox[{
         SuperscriptBox["a", "8"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"2", " ", 
            SuperscriptBox["b", "2"]}], "-", "S"}], ")"}]}], "-", 
        RowBox[{
         SuperscriptBox["c", "8"], " ", "S"}], "-", 
        RowBox[{
         SuperscriptBox["b", "6"], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["c", "4"], "-", 
           RowBox[{"6", " ", 
            SuperscriptBox["c", "2"], " ", "S"}]}], ")"}]}], "+", 
        RowBox[{
         SuperscriptBox["b", "4"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"-", "3"}], " ", 
            SuperscriptBox["c", "6"]}], "+", 
           RowBox[{"10", " ", 
            SuperscriptBox["c", "4"], " ", "S"}]}], ")"}]}], "+", 
        RowBox[{
         SuperscriptBox["b", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"3", " ", 
            SuperscriptBox["c", "8"]}], "+", 
           RowBox[{"2", " ", 
            SuperscriptBox["c", "6"], " ", "S"}]}], ")"}]}], "+", 
        RowBox[{
         SuperscriptBox["a", "6"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"-", "8"}], " ", 
            SuperscriptBox["b", "4"]}], "+", 
           RowBox[{"4", " ", 
            SuperscriptBox["c", "2"], " ", "S"}], "+", 
           RowBox[{
            SuperscriptBox["b", "2"], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               RowBox[{"-", "9"}], " ", 
               SuperscriptBox["c", "2"]}], "+", 
              RowBox[{"2", " ", "S"}]}], ")"}]}]}], ")"}]}], "+", 
        RowBox[{
         SuperscriptBox["a", "4"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"12", " ", 
            SuperscriptBox["b", "6"]}], "-", 
           RowBox[{"6", " ", 
            SuperscriptBox["c", "4"], " ", "S"}], "+", 
           RowBox[{
            SuperscriptBox["b", "4"], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"17", " ", 
               SuperscriptBox["c", "2"]}], "+", 
              RowBox[{"2", " ", "S"}]}], ")"}]}], "+", 
           RowBox[{
            SuperscriptBox["b", "2"], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"15", " ", 
               SuperscriptBox["c", "4"]}], "-", 
              RowBox[{"2", " ", 
               SuperscriptBox["c", "2"], " ", "S"}]}], ")"}]}]}], ")"}]}], "-", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"8", " ", 
            SuperscriptBox["b", "8"]}], "-", 
           RowBox[{"4", " ", 
            SuperscriptBox["c", "6"], " ", "S"}], "+", 
           RowBox[{
            SuperscriptBox["b", "6"], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"7", " ", 
               SuperscriptBox["c", "2"]}], "+", 
              RowBox[{"6", " ", "S"}]}], ")"}]}], "+", 
           RowBox[{"6", " ", 
            SuperscriptBox["b", "4"], " ", 
            RowBox[{"(", 
             RowBox[{
              SuperscriptBox["c", "4"], "+", 
              RowBox[{"2", " ", 
               SuperscriptBox["c", "2"], " ", "S"}]}], ")"}]}], "+", 
           RowBox[{
            SuperscriptBox["b", "2"], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"11", " ", 
               SuperscriptBox["c", "6"]}], "+", 
              RowBox[{"2", " ", 
               SuperscriptBox["c", "4"], " ", "S"}]}], ")"}]}]}], ")"}]}]}], 
       ")"}]}]}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{3.954734617198675*^9, 3.954734816513953*^9, 
  3.9547348978013387`*^9, 3.9547456202139783`*^9, 3.954745705154098*^9, 
  3.954746221829569*^9, 3.954747260051348*^9, 3.954747694515775*^9, 
  3.9547581196008162`*^9, 3.9547583599511127`*^9, 3.954758413053156*^9, 
  3.954758453065132*^9, 3.961123201761051*^9, 3.961412970374134*^9},
 CellLabel->
  "Out[295]=",ExpressionUUID->"b098031c-9df6-4f57-93d5-e5358be81036"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"orthodiagonalQuadQ", "[", 
  RowBox[{"{", 
   RowBox[{"ptF", ",", "ptG", ",", "ptH", ",", "ptI"}], "}"}], "]"}]], "Input",
 CellChangeTimes->{{3.9547581609478846`*^9, 3.954758162349493*^9}},
 CellLabel->
  "In[296]:=",ExpressionUUID->"a63d8f5a-2275-da47-9b4c-2e31071186a5"],

Cell[BoxData["True"], "Output",
 CellChangeTimes->{3.954758166997286*^9, 3.954758265104833*^9, 
  3.95475831942744*^9, 3.954758366168917*^9, 3.954758419036211*^9, 
  3.954758459505897*^9, 3.9611232083561325`*^9, 3.9614129750720263`*^9},
 CellLabel->
  "Out[296]=",ExpressionUUID->"0746f852-c4a1-43b5-b30f-ea8986d7dd20"]
}, Open  ]]
}, Closed]]
}, Open  ]]
}, Open  ]]
},
WindowSize->{1294, 655},
WindowMargins->{{259, Automatic}, {Automatic, 86}},
FrontEndVersion->"14.2 for Mac OS X x86 (64-bit) (March 16, 2025)",
StyleDefinitions->"Default.nb",
ExpressionUUID->"2c987011-4232-1444-860d-88047ca04ba6"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[580, 22, 389, 6, 96, "Title",ExpressionUUID->"29001ab6-6556-7b4b-a45f-7ca429ca0ceb"],
Cell[972, 30, 1484, 25, 164, "Text",ExpressionUUID->"22c83543-03f0-524a-b077-52bf40ea5d06"],
Cell[CellGroupData[{
Cell[2481, 59, 200, 4, 66, "Section",ExpressionUUID->"9f6088f9-a2be-3140-964a-e41e398b8645"],
Cell[CellGroupData[{
Cell[2706, 67, 1793, 40, 94, "Input",ExpressionUUID->"7895159c-a127-8b44-944b-25ce84d4f88d"],
Cell[4502, 109, 963, 25, 70, "Output",ExpressionUUID->"65da89bb-a627-48ff-9d4d-23258ae282d1"]
}, Open  ]],
Cell[CellGroupData[{
Cell[5502, 139, 775, 22, 43, "Input",ExpressionUUID->"3eb12783-78d1-9b4d-8549-a0e447faf612"],
Cell[6280, 163, 1377, 35, 70, "Output",ExpressionUUID->"5231a96e-2ae2-4713-9357-a20b75b5d6ea"]
}, Open  ]],
Cell[CellGroupData[{
Cell[7694, 203, 2168, 61, 69, "Input",ExpressionUUID->"ba7de94b-b034-de42-a94a-b67c19a69b18"],
Cell[9865, 266, 987, 25, 70, "Output",ExpressionUUID->"76f4824e-4e28-4223-9161-a716c8dce21b"]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[10901, 297, 255, 4, 52, "Section",ExpressionUUID->"fc2fcd82-4d50-ec47-b5a7-8944aef04ea5"],
Cell[11159, 303, 9191, 245, 585, "Input",ExpressionUUID->"c44d3c99-d821-aa44-a5bf-67b591807924"]
}, Closed]],
Cell[CellGroupData[{
Cell[20387, 553, 211, 4, 52, "Section",ExpressionUUID->"2609bf4c-7f5c-314e-a744-f86d4be283dd"],
Cell[20601, 559, 25542, 424, 113, "Text",ExpressionUUID->"27562332-302c-684c-a6e9-c7f5988655e4"],
Cell[CellGroupData[{
Cell[46168, 987, 511, 12, 29, "Input",ExpressionUUID->"92df2acf-ef77-6d4c-a144-72124269f2b6"],
Cell[46682, 1001, 1455, 43, 35, "Output",ExpressionUUID->"e69dcba2-5ff8-43be-addc-2f093bd70f3c"]
}, Open  ]],
Cell[CellGroupData[{
Cell[48174, 1049, 455, 7, 53, "Subsection",ExpressionUUID->"b06d3d7c-fd07-4143-89eb-4262fe6db97f"],
Cell[CellGroupData[{
Cell[48654, 1060, 522, 14, 29, "Input",ExpressionUUID->"8a80128a-ca1a-0843-a2a0-a916a2c41a68"],
Cell[49179, 1076, 1696, 55, 35, "Output",ExpressionUUID->"f97083a2-a7c3-4eaf-9ccf-24156358a766"]
}, Open  ]],
Cell[CellGroupData[{
Cell[50912, 1136, 1137, 28, 49, "Input",ExpressionUUID->"da306cb6-cdbd-b447-9da5-a1d78f32c355"],
Cell[52052, 1166, 28018, 816, 353, "Output",ExpressionUUID->"8e593f59-5730-4fb4-a86a-8c51e827c60a"]
}, Open  ]],
Cell[CellGroupData[{
Cell[80107, 1987, 295, 6, 29, "Input",ExpressionUUID->"78b6f02c-d7d8-a344-8ead-13ac4448af8f"],
Cell[80405, 1995, 319, 5, 33, "Output",ExpressionUUID->"a26cf30f-d129-44e7-9c91-dfcb62ad7ad1"]
}, Open  ]],
Cell[80739, 2003, 255, 4, 33, "Text",ExpressionUUID->"b5a79090-5d8a-664b-a76e-251c2479c317"],
Cell[CellGroupData[{
Cell[81019, 2011, 507, 14, 29, "Input",ExpressionUUID->"a652668f-bd5f-9f4a-a808-374b5c50170f"],
Cell[81529, 2027, 40539, 1198, 625, "Output",ExpressionUUID->"635425f6-6caf-4c23-855c-c98b908936d7"]
}, Open  ]],
Cell[CellGroupData[{
Cell[122105, 3230, 400, 11, 29, "Input",ExpressionUUID->"35a92d1f-c427-9e4d-8430-9c5cb57fd82d"],
Cell[122508, 3243, 330, 7, 33, "Output",ExpressionUUID->"c4b235fa-26af-48b8-bf9c-4f66beb9ba0b"]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[122887, 3256, 509, 8, 37, "Subsection",ExpressionUUID->"edfd1f34-ecd8-8141-abb0-b280d44e94ec"],
Cell[CellGroupData[{
Cell[123421, 3268, 569, 15, 29, "Input",ExpressionUUID->"f7fe21ca-a76c-b048-b53f-646da5a416f4"],
Cell[123993, 3285, 2470, 76, 35, "Output",ExpressionUUID->"0d1b379b-3645-415a-a525-c878c7b73546"]
}, Open  ]],
Cell[CellGroupData[{
Cell[126500, 3366, 1135, 28, 49, "Input",ExpressionUUID->"f25eccec-9cbe-eb47-b2cb-969a73dc08df"],
Cell[127638, 3396, 16268, 502, 285, "Output",ExpressionUUID->"c2f43cc2-c4df-4c6d-bea1-adf921b8df08"]
}, Open  ]],
Cell[CellGroupData[{
Cell[143943, 3903, 297, 6, 29, "Input",ExpressionUUID->"aaafa899-1bc1-0243-8905-f3f5a463e84b"],
Cell[144243, 3911, 293, 5, 33, "Output",ExpressionUUID->"195f9901-1427-4da1-8470-594e1418cc2c"]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[144585, 3922, 561, 9, 37, "Subsection",ExpressionUUID->"c76dcc49-5055-ed45-960f-2079d27a3b0e"],
Cell[CellGroupData[{
Cell[145171, 3935, 612, 15, 29, "Input",ExpressionUUID->"5d41aa62-3709-f14f-9c76-e3eb2c2e9f8b"],
Cell[145786, 3952, 2303, 75, 35, "Output",ExpressionUUID->"8d23ffa4-e458-40a7-956d-94075b1c5f64"]
}, Open  ]],
Cell[CellGroupData[{
Cell[148126, 4032, 1135, 28, 49, "Input",ExpressionUUID->"e7feb55e-d3c4-4c44-8204-16ff3e4fc5db"],
Cell[149264, 4062, 33497, 994, 421, "Output",ExpressionUUID->"b098031c-9df6-4f57-93d5-e5358be81036"]
}, Open  ]],
Cell[CellGroupData[{
Cell[182798, 5061, 297, 6, 29, "Input",ExpressionUUID->"a63d8f5a-2275-da47-9b4c-2e31071186a5"],
Cell[183098, 5069, 319, 5, 33, "Output",ExpressionUUID->"0746f852-c4a1-43b5-b30f-ea8986d7dd20"]
}, Open  ]]
}, Closed]]
}, Open  ]]
}, Open  ]]
}
]
*)

